/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens.email;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.internal.accesstokens.event.AccessTokenEvent;
import com.atlassian.bitbucket.mail.MailMessage;
import java.util.function.Function;

public class AccessTokenMailBuilder
implements Function<MailMessage.Builder, MailMessage.Builder> {
    static final String IN_REPLY_TO_HEADER = "in-reply-to";
    static final String MESSAGE_ID_HEADER = "message-id";
    static final String REFERENCES_HEADER = "references";
    private static final String ID_FORMAT = "%s-%s";
    private final String messageId;
    private final String replyTo;

    public AccessTokenMailBuilder(AccessTokenEvent event, String type) {
        String formattedId = String.format(ID_FORMAT, type, event.getToken().getId().replaceAll("[ <>@]", ""));
        this.messageId = String.format("<%s-%3$d@%2$s>", formattedId, Product.NAME, System.nanoTime());
        this.replyTo = String.format("<%s@%s>", formattedId, Product.NAME);
    }

    @Override
    public MailMessage.Builder apply(MailMessage.Builder builder) {
        return builder.header(MESSAGE_ID_HEADER, this.messageId).header(IN_REPLY_TO_HEADER, this.replyTo).header(REFERENCES_HEADER, this.replyTo);
    }
}

