/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens.email;

import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.internal.accesstokens.email.AccessTokenMailBuilder;
import com.atlassian.bitbucket.internal.accesstokens.event.AccessTokenEvent;
import com.atlassian.bitbucket.internal.accesstokens.event.PersonalAccessTokenCreatedEvent;
import com.atlassian.bitbucket.internal.accesstokens.event.PersonalAccessTokenDeletedEvent;
import com.atlassian.bitbucket.internal.accesstokens.event.PersonalAccessTokenModifiedEvent;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.mail.SoyMailBuilder;
import com.atlassian.bitbucket.mail.SoyMailMessageRequest;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.event.api.EventListener;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.springframework.stereotype.Component;

@Component
public class AccessTokenMailer {
    private static final String NOTIFICATION_EMAIL_STYLES_MODULE = "com.atlassian.bitbucket.server.bitbucket-notification:notification-email-styles";
    private static final String SOY_EMAIL_TEMPLATE_MODULE = "com.atlassian.bitbucket.server.bitbucket-access-tokens:access-token-email-templates";
    private static final String SOY_TEMPLATE_BASE = "bitbucket.internal.notification.email.access.token";
    private static final String TOKEN_EMAIL_STYLES_MODULE = "com.atlassian.bitbucket.server.bitbucket-access-tokens:access-token-email-styles";
    private final MailService mailService;
    private final NavBuilder navBuilder;
    private final ApplicationPropertiesService propertiesService;
    private final SoyMailBuilder soyMailBuilder;

    public AccessTokenMailer(@Nonnull NavBuilder navBuilder, @Nonnull MailService mailService, @Nonnull ApplicationPropertiesService propertiesService, @Nonnull SoyMailBuilder soyMailBuilder) {
        this.mailService = mailService;
        this.navBuilder = navBuilder;
        this.propertiesService = propertiesService;
        this.soyMailBuilder = soyMailBuilder;
    }

    @EventListener
    public void created(PersonalAccessTokenCreatedEvent event) {
        if (this.mailService.isHostConfigured()) {
            ImmutableMap.Builder<String, Object> context = this.getContext(event);
            this.renderAndSend((Map<String, Object>)context.build(), event, "bitbucket.internal.notification.email.access.token.added", new I18nKey("bitbucket.email.access.tokens.added.subject", new Object[]{this.propertiesService.getDisplayName()}), "created");
        }
    }

    @EventListener
    public void deleted(PersonalAccessTokenDeletedEvent event) {
        if (this.mailService.isHostConfigured()) {
            ImmutableMap.Builder<String, Object> context = this.getContext(event);
            this.renderAndSend((Map<String, Object>)context.build(), event, "bitbucket.internal.notification.email.access.token.deleted", new I18nKey("bitbucket.email.access.tokens.deleted.subject", new Object[]{this.propertiesService.getDisplayName()}), "deleted");
        }
    }

    @EventListener
    public void modified(PersonalAccessTokenModifiedEvent event) {
        if (this.mailService.isHostConfigured()) {
            ImmutableMap.Builder<String, Object> context = this.getContext(event);
            context.put((Object)"oldTokenName", (Object)event.getOldToken().getName()).put((Object)"permissionsChanged", (Object)(!event.getOldToken().getPermissions().equals(event.getToken().getPermissions()) ? 1 : 0));
            this.renderAndSend((Map<String, Object>)context.build(), event, "bitbucket.internal.notification.email.access.token.modified", new I18nKey("bitbucket.email.access.tokens.modified.subject", new Object[]{this.propertiesService.getDisplayName()}), "modified");
        }
    }

    private ImmutableMap.Builder<String, Object> getContext(AccessTokenEvent event) {
        return ImmutableMap.builder().put((Object)"user", (Object)event.getToken().getUser()).put((Object)"date", (Object)event.getDate()).put((Object)"moduleKey", (Object)NOTIFICATION_EMAIL_STYLES_MODULE).put((Object)"tokenName", (Object)event.getToken().getName()).put((Object)"manageUrl", (Object)(this.navBuilder.buildAbsolute() + "/plugins/servlet/access-tokens/"));
    }

    private void renderAndSend(Map<String, Object> context, AccessTokenEvent event, String templateName, I18nKey subjectKey, String type) {
        Iterable messages = this.soyMailBuilder.build(new SoyMailMessageRequest.Builder().cssModuleKey(TOKEN_EMAIL_STYLES_MODULE).context(context).messageEffector((Function)new AccessTokenMailBuilder(event, type)).recipients(Collections.singleton(event.getToken().getUser())).soyTemplateModuleKey(SOY_EMAIL_TEMPLATE_MODULE).soyTemplateName(templateName).subjectKey(subjectKey).build());
        messages.forEach(arg_0 -> ((MailService)this.mailService).submit(arg_0));
    }
}

