/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens.event;

import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.internal.accesstokens.AccessToken;
import com.atlassian.bitbucket.permission.Permission;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Set;

@TransactionAware
public class AccessTokenEvent
extends ApplicationEvent {
    protected final AccessToken token;

    public AccessTokenEvent(@Nonnull Object source, @Nonnull AccessToken token) {
        super(source);
        this.token = Objects.requireNonNull(token, "token");
    }

    @Nullable
    public Integer getExpiryDays() {
        return this.token.getExpiryDays().orElse(null);
    }

    @Nonnull
    public Set<Permission> getPermissions() {
        return this.token.getPermissions();
    }

    @Nonnull
    public AccessToken getToken() {
        return this.token;
    }

    @Nonnull
    public String getTokenId() {
        return this.token.getId();
    }
}

