/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens.event;

import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.bitbucket.audit.AuditEventConverter;
import com.atlassian.bitbucket.internal.accesstokens.AccessToken;
import com.atlassian.bitbucket.internal.accesstokens.event.AccessTokenEvent;
import com.atlassian.bitbucket.internal.accesstokens.event.PersonalAccessTokenModifiedEvent;
import com.atlassian.bitbucket.internal.accesstokens.event.ScopeAccessTokenCreatedEvent;
import com.atlassian.bitbucket.internal.accesstokens.event.ScopeAccessTokenDeletedEvent;
import com.atlassian.bitbucket.internal.accesstokens.event.ScopeAccessTokenEvent;
import com.atlassian.bitbucket.internal.accesstokens.event.ScopeAccessTokenModifiedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.AuditUtils;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.Set;
import java.util.stream.Collectors;

public class AccessTokenEventConverter
implements AuditEventConverter<AccessTokenEvent> {
    @VisibleForTesting
    static final String ATTR_EXPIRY = "bitbucket.access.tokens.audit.attribute.accesstoken.expiry";
    @VisibleForTesting
    static final String ATTR_ID = "bitbucket.access.tokens.audit.attribute.accesstoken.id";
    @VisibleForTesting
    static final String ATTR_NAME = "bitbucket.access.tokens.audit.attribute.accesstoken.name";
    @VisibleForTesting
    static final String ATTR_PERMISSIONS = "bitbucket.access.tokens.audit.attribute.accesstoken.permissions";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_TOKEN_CREATED = "bitbucket.access.tokens.audit.action.accesstokencreated.repository";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_TOKEN_DELETED = "bitbucket.access.tokens.audit.action.accesstokendeleted.repository";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_TOKEN_MODIFIED = "bitbucket.access.tokens.audit.action.accesstokenmodified.repository";

    @Nonnull
    public AuditEvent convert(@Nonnull AccessTokenEvent event, final @Nonnull AuditEvent.Builder builder) {
        AccessToken token = event.getToken();
        if (event instanceof ScopeAccessTokenEvent) {
            final ScopeAccessTokenEvent scopeEvent = (ScopeAccessTokenEvent)((Object)event);
            scopeEvent.getScope().accept((ScopeVisitor)new ScopeVisitor<Void>(){

                public Void visit(@Nonnull ProjectScope scope) {
                    builder.affectedObject(AuditUtils.auditResourceForProject((Project)scope.getProject()));
                    return null;
                }

                public Void visit(@Nonnull RepositoryScope scope) {
                    builder.actionI18nKey(AccessTokenEventConverter.toRepositoryActionI18nKey(scopeEvent)).categoryI18nKey("bitbucket.service.audit.category.repositories").affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)scope.getRepository()));
                    return null;
                }
            });
        } else {
            builder.affectedObject(AuditUtils.auditResourceForUser((ApplicationUser)token.getUser())).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_ID, (String)token.getId()).build());
        }
        if (event instanceof PersonalAccessTokenModifiedEvent) {
            AccessTokenEventConverter.addChangedValues(builder, token, ((PersonalAccessTokenModifiedEvent)event).getOldToken());
        } else {
            AccessTokenEventConverter.addExtraAttributes(builder, token);
        }
        token.getExpiryDays().ifPresent(expiryDays -> builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_EXPIRY, (String)String.valueOf(expiryDays)).build()));
        return builder.build();
    }

    private static String toRepositoryActionI18nKey(ScopeAccessTokenEvent event) {
        if (event instanceof ScopeAccessTokenCreatedEvent) {
            return ACTION_REPOSITORY_TOKEN_CREATED;
        }
        if (event instanceof ScopeAccessTokenModifiedEvent) {
            return ACTION_REPOSITORY_TOKEN_MODIFIED;
        }
        if (event instanceof ScopeAccessTokenDeletedEvent) {
            return ACTION_REPOSITORY_TOKEN_DELETED;
        }
        return null;
    }

    private static void addChangedValues(AuditEvent.Builder builder, AccessToken newToken, AccessToken oldToken) {
        builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_NAME).from(oldToken.getName()).to(newToken.getName()).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_PERMISSIONS).from(AccessTokenEventConverter.toString(oldToken.getPermissions())).to(AccessTokenEventConverter.toString(newToken.getPermissions())).build());
    }

    private static void addExtraAttributes(@Nonnull AuditEvent.Builder builder, AccessToken token) {
        builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_NAME, (String)token.getName()).build());
        Set<Permission> permissions = token.getPermissions();
        if (!permissions.isEmpty()) {
            builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_PERMISSIONS, (String)AccessTokenEventConverter.toString(permissions)).build());
        }
    }

    private static String toString(Set<Permission> permissions) {
        if (permissions.isEmpty()) {
            return null;
        }
        return permissions.stream().map(Enum::name).collect(Collectors.joining(", "));
    }
}

