/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens.event;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.Objects;

@AsynchronousPreferred
@EventName(value="stash.accesstoken.summary")
public class AccessTokenSummaryEvent
extends ApplicationEvent {
    private final int authenticatedRecently;
    private final Duration interval;
    private final int total;

    public AccessTokenSummaryEvent(@Nonnull Object source, int total, int authenticatedRecently, @Nonnull Duration interval) {
        super(Objects.requireNonNull(source, "source"));
        this.total = total;
        this.authenticatedRecently = authenticatedRecently;
        this.interval = Objects.requireNonNull(interval, "interval");
    }

    public int getAuthenticatedRecently() {
        return this.authenticatedRecently;
    }

    public long getIntervalHours() {
        return this.interval.toHours();
    }

    public int getTotal() {
        return this.total;
    }
}

