/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenSettingsService;
import com.atlassian.bitbucket.internal.accesstokens.rest.RestAccessTokenSettings;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@AdminOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Path(value="admin")
public class AccessTokenSettingsResource {
    private final I18nService i18nService;
    private final AccessTokenSettingsService settingsService;

    @Inject
    public AccessTokenSettingsResource(AccessTokenSettingsService settingsService, I18nService i18nService) {
        this.i18nService = i18nService;
        this.settingsService = settingsService;
    }

    @Operation(hidden=true)
    @DELETE
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response delete() {
        this.settingsService.removeMaxExpiry();
        return this.get();
    }

    @Operation(hidden=true)
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response get() {
        return ResponseFactory.ok((Object)((Object)new RestAccessTokenSettings(this.settingsService.getMaxExpiry().orElse(null)))).build();
    }

    @Operation(hidden=true)
    @PUT
    @WebSudoRequired
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response set(RestAccessTokenSettings createAdminSettingsRequest) {
        try {
            this.settingsService.setMaxExpiry(createAdminSettingsRequest.getMaxExpiryDays());
        }
        catch (NumberFormatException e) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.access.tokens.error.admin.expiry", new Object[0]));
        }
        return this.get();
    }
}

