/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.util.RestPermissionUtils;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.accesstokens.AccessToken;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenCreateRequest;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenSearchRequest;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenService;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenUpdateRequest;
import com.atlassian.bitbucket.internal.accesstokens.RawAccessToken;
import com.atlassian.bitbucket.internal.accesstokens.rest.RestAccessToken;
import com.atlassian.bitbucket.internal.accesstokens.rest.RestAccessTokenRequest;
import com.atlassian.bitbucket.internal.accesstokens.rest.RestRawAccessToken;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
public class BaseEntityAccessTokenResource<T> {
    protected final AccessTokenService<T> accessTokenService;
    protected final I18nService i18nService;

    public BaseEntityAccessTokenResource(I18nService i18nService, AccessTokenService<T> accessTokenService) {
        this.i18nService = i18nService;
        this.accessTokenService = accessTokenService;
    }

    @Operation(description="Delete the access token identified by the given ID.", summary="Delete a HTTP token")
    @Parameters(value={@Parameter(description="The token id.", in=ParameterIn.PATH, name="tokenId")})
    @ResponseDocs(value={@ResponseDoc(documentation="An empty response indicating that the token has been deleted.", responseCode=204), @ResponseDoc(documentation="The currently authenticated user is not permitted to delete an access token on behalf of this user or authentication failed.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified user or token does not exist.", responseCode=404, restError=true)})
    @DELETE
    @Path(value="/{tokenId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteById(@PathParam(value="tokenId") String tokenId, @Context HttpServletRequest request) {
        this.deleteByIdChecks(tokenId, request);
        if (this.accessTokenService.deleteById(tokenId).isPresent()) {
            return ResponseFactory.noContent().build();
        }
        return ResponseFactory.notFound().build();
    }

    @Operation(description="Get the access token identified by the given ID.", summary="Get HTTP token by ID")
    @Parameters(value={@Parameter(description="The token id.", in=ParameterIn.PATH, name="tokenId")})
    @ResponseDocs(value={@ResponseDoc(documentation="A response containing the access token and associated details.", representation=RestAccessToken.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not permitted to get access tokens on behalf of this user or authentication failed.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified user or token does not exist.", responseCode=404, restError=true)})
    @GET
    @Path(value="/{tokenId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getById(@PathParam(value="tokenId") String tokenId, @Context HttpServletRequest request) {
        Optional<AccessToken> accessToken = this.accessTokenService.getById(tokenId);
        return accessToken.map(token -> {
            this.getByIdChecks((AccessToken)token, request);
            return ResponseFactory.ok((Object)((Object)new RestAccessToken((AccessToken)token))).build();
        }).orElseGet(() -> ResponseFactory.notFound().build());
    }

    @Operation(description="Modify an access token according to the given request. Any fields not specified will not be altered.", summary="Update HTTP token")
    @Parameters(value={@Parameter(description="The token id.", in=ParameterIn.PATH, name="tokenId")})
    @ResponseDocs(value={@ResponseDoc(documentation="A response containing the updated access token and associated details.", representation=RestAccessToken.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not permitted to update an access token on behalf of this user or authentication failed.", responseCode=401, restError=true), @ResponseDoc(documentation="One of the provided permission levels are unknown.", responseCode=400, restError=true)})
    @RequestBody(description="The request containing the details of the access token to modify", content={@Content(schema=@Schema(implementation=RestAccessTokenRequest.class))})
    @POST
    @Path(value="/{tokenId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response updateAccessToken(@PathParam(value="tokenId") String tokenId, RestAccessTokenRequest editTokenRequest, @Context HttpServletRequest request) {
        this.updateAccessTokenChecks(tokenId, request);
        AccessTokenUpdateRequest modifyRequest = AccessTokenUpdateRequest.builder(tokenId).name(StringUtils.trimToNull((String)editTokenRequest.getName())).permissions(this.convertToPermissions(editTokenRequest.getPermissions())).build();
        AccessToken accessToken = this.accessTokenService.update(modifyRequest);
        return ResponseFactory.ok((Object)((Object)new RestAccessToken(accessToken))).build();
    }

    protected AccessTokenCreateRequest<T> buildCreateRequest(AccessTokenCreateRequest.Builder<T> builder, RestAccessTokenRequest restRequest) {
        return builder.name(this.getAndValidateName(restRequest)).permissions(this.getAndValidatePermissions(restRequest)).expiryDays(this.getAndValidateExpiry(restRequest)).build();
    }

    protected Response createAccessToken(T entity, RestAccessTokenRequest restRequest) {
        AccessTokenCreateRequest<T> request = this.buildCreateRequest(new AccessTokenCreateRequest.Builder<T>(entity), restRequest);
        RawAccessToken rawAccessToken = this.accessTokenService.create(request);
        return ResponseFactory.ok((Object)((Object)new RestRawAccessToken(rawAccessToken))).build();
    }

    protected void deleteByIdChecks(String tokenId, HttpServletRequest request) {
    }

    protected Page<AccessToken> getAllForEntity(T entity, PageRequest pageRequest) {
        AccessTokenSearchRequest<T> request = new AccessTokenSearchRequest.Builder<T>(entity).build();
        return this.accessTokenService.search(request, pageRequest);
    }

    protected void getByIdChecks(AccessToken token, HttpServletRequest request) {
    }

    protected void updateAccessTokenChecks(String tokenId, HttpServletRequest request) {
    }

    private Set<Permission> convertToPermissions(Collection<String> permissionStrings) {
        return permissionStrings.stream().map(permission -> RestPermissionUtils.parsePermission((I18nService)this.i18nService, (String)permission, null)).collect(Collectors.toSet());
    }

    private Integer getAndValidateExpiry(RestAccessTokenRequest restRequest) {
        Integer expiryDays = restRequest.getExpiryDays();
        if (expiryDays != null && expiryDays <= 0) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.access.tokens.error.create.expiry", new Object[0]));
        }
        return expiryDays;
    }

    private String getAndValidateName(RestAccessTokenRequest restRequest) {
        String name = StringUtils.trimToNull((String)restRequest.getName());
        if (name == null) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.access.tokens.error.create.namemissing", new Object[0]));
        }
        return name;
    }

    private Set<Permission> getAndValidatePermissions(RestAccessTokenRequest restRequest) {
        Set<Permission> permissions = this.convertToPermissions(restRequest.getPermissions());
        if (permissions.isEmpty()) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.rest.access.tokens.error.create.permissionsmissing", new Object[0]));
        }
        return permissions;
    }
}

