/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.accesstokens.AccessToken;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenService;
import com.atlassian.bitbucket.internal.accesstokens.rest.BaseEntityAccessTokenResource;
import com.atlassian.bitbucket.internal.accesstokens.rest.RestAccessToken;
import com.atlassian.bitbucket.internal.accesstokens.rest.RestAccessTokenRequest;
import com.atlassian.bitbucket.internal.accesstokens.rest.RestRawAccessToken;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.ScopeResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;

@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Tag(name="Authentication")
@LicensedOnly
@Singleton
@Path(value="projects/{projectKey}/repos/{repositorySlug}")
public class RepositoryAccessTokenResource
extends BaseEntityAccessTokenResource<Scope> {
    @Inject
    public RepositoryAccessTokenResource(I18nService i18nService, @Named(value="scopeAccessTokenService") AccessTokenService<Scope> accessTokenService) {
        super(i18nService, accessTokenService);
    }

    @Override
    @Operation(description="Create an access token for the repository according to the given request.", summary="Create repository HTTP token")
    @ResponseDocs(value={@ResponseDoc(documentation="A response containing the raw access token and associated details.", representation=RestRawAccessToken.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not permitted to create an access token for this repository or authentication failed.", responseCode=401, restError=true), @ResponseDoc(documentation="One of the following error cases occurred (check the error message for more details).\n\n- The request does not contain a token name- The request does not contain a list of permissions, or the list of permissions is empty- One of the provided permission levels are unknown- The repository already has the maximum number of tokens", responseCode=400, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @RequestBody(description="The request containing the details of the access token to create.", content={@Content(schema=@Schema(implementation=RestAccessTokenRequest.class))})
    @PUT
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createAccessToken(@BeanParam ScopeResolver scopeResolver, RestAccessTokenRequest restRequest) {
        return this.createAccessToken(scopeResolver.getScope(), restRequest);
    }

    @Operation(description="Get all access tokens associated with the given repository.", summary="Get repository HTTP tokens")
    @ResponseDocs(value={@ResponseDoc(documentation="A response containing a page of access tokens and associated details.", paged=true, representation=RestAccessToken.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not permitted to get access tokens for this repository or authentication failed.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified repository does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getAllAccessTokens(@BeanParam ScopeResolver scopeResolver, @BeanParam PageRequestResolver pageRequestResolver) {
        Page<AccessToken> accessTokens = this.getAllForEntity(scopeResolver.getScope(), pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(accessTokens, RestAccessToken::new)).build();
    }
}

