/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens.rest;

import com.atlassian.bitbucket.internal.accesstokens.AccessToken;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang3.time.DateUtils;

@JsonSerialize
@JsonSurrogate(value=AccessToken.class)
public class RestAccessToken
extends RestMapEntity {
    private static final String CREATED_DATE = "createdDate";
    private static final String EXPIRY_DATE = "expiryDate";
    private static final String ID = "id";
    private static final String LAST_AUTHENTICATED = "lastAuthenticated";
    private static final String NAME = "name";
    private static final String PERMISSIONS = "permissions";
    private static final String USER = "user";

    public RestAccessToken() {
    }

    public RestAccessToken(AccessToken accessToken) {
        this(accessToken.getId(), accessToken.getCreatedDate(), accessToken.getExpiryDays().map(days -> DateUtils.addDays((Date)accessToken.getCreatedDate(), (int)days)).orElse(null), accessToken.getLastAuthenticated().orElse(null), accessToken.getName(), accessToken.getPermissions(), new RestApplicationUser(accessToken.getUser()));
    }

    public RestAccessToken(String tokenId, Date createdDate, Date expiryDate, Date lastAuthenticated, String tokenName, Set<Permission> permissions, RestApplicationUser user) {
        this.put(ID, tokenId);
        this.put(CREATED_DATE, createdDate);
        this.putIfNotNull(LAST_AUTHENTICATED, lastAuthenticated);
        this.putIfNotNull(EXPIRY_DATE, expiryDate);
        this.put(NAME, tokenName);
        this.put(PERMISSIONS, permissions);
        this.put(USER, user);
    }

    @JsonProperty
    public Date getCreatedDate() {
        return (Date)this.get(CREATED_DATE);
    }

    @JsonProperty
    @Schema(example="252973515069")
    public String getID() {
        return this.getStringProperty(ID);
    }

    @JsonProperty
    @Schema(example="My access token")
    public String getName() {
        return this.getStringProperty(NAME);
    }
}

