/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens.rest;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@JsonSerialize
public class RestAccessTokenRequest
extends RestMapEntity {
    private static final String EXPIRY_DAYS = "expiryDays";
    private static final String NAME = "name";
    private static final String PERMISSIONS = "permissions";

    public RestAccessTokenRequest() {
    }

    private RestAccessTokenRequest(String name, Collection<Permission> permissions, String expiryDays) {
        this.put(NAME, name);
        this.put(PERMISSIONS, permissions.stream().map(Enum::name).collect(Collectors.toSet()));
        this.put(EXPIRY_DAYS, expiryDays);
    }

    @Nullable
    public Integer getExpiryDays() {
        try {
            String expiryDays = this.getStringProperty(EXPIRY_DAYS);
            if (StringUtils.isBlank((CharSequence)expiryDays)) {
                return null;
            }
            return Integer.parseInt(expiryDays);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @JsonProperty
    @Nullable
    @Schema(example="My access token")
    public String getName() {
        return this.getStringProperty(NAME);
    }

    @Nonnull
    @Schema(example="[\"REPO_ADMIN\", \"PROJECT_READ\"]")
    public Set<String> getPermissions() {
        Object permissionsObject = this.get(PERMISSIONS);
        if (permissionsObject != null && permissionsObject instanceof Collection) {
            return ((Collection)permissionsObject).stream().filter(permission -> permission instanceof String).map(String.class::cast).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }
}

