/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.accesstokens.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.accesstokens.AccessToken;
import com.atlassian.bitbucket.internal.accesstokens.AccessTokenService;
import com.atlassian.bitbucket.internal.accesstokens.rest.BaseEntityAccessTokenResource;
import com.atlassian.bitbucket.internal.accesstokens.rest.RestAccessToken;
import com.atlassian.bitbucket.internal.accesstokens.rest.RestAccessTokenRequest;
import com.atlassian.bitbucket.internal.accesstokens.rest.RestRawAccessToken;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.UserResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.sal.api.websudo.WebSudoManager;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@PathParamDocs(value={@PathParamDoc(name="userSlug", documentation="The user slug.")})
@Tag(name="Authentication")
@LicensedOnly
@Singleton
@Path(value="users/{userSlug}")
public class UserAccessTokenResource
extends BaseEntityAccessTokenResource<ApplicationUser> {
    private final AuthenticationContext authenticationContext;
    private final WebSudoManager webSudoManager;

    @Inject
    public UserAccessTokenResource(@Named(value="userAccessTokenService") AccessTokenService<ApplicationUser> accessTokenService, AuthenticationContext authenticationContext, I18nService i18nService, WebSudoManager webSudoManager) {
        super(i18nService, accessTokenService);
        this.authenticationContext = authenticationContext;
        this.webSudoManager = webSudoManager;
    }

    @Override
    @Operation(description="Create an access token for the user according to the given request.", summary="Create personal HTTP token")
    @ResponseDocs(value={@ResponseDoc(documentation="A response containing the raw access token and associated details.", representation=RestRawAccessToken.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not permitted to create an access token on behalf of this user or authentication failed", responseCode=401, restError=true), @ResponseDoc(documentation="One of the following error cases occurred (check the error message for more details).\n\n- The request does not contain a token name\n- The request does not contain a list of permissions, or the list of permissions is empty\n- One of the provided permission levels are unknown\n- The user already has their maximum number of tokens\n", responseCode=400, restError=true), @ResponseDoc(documentation="The specified user does not exist.", responseCode=404, restError=true)})
    @RequestBody(description="The request containing the details of the access token to create.", content={@Content(schema=@Schema(implementation=RestAccessTokenRequest.class))})
    @PUT
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createAccessToken(@BeanParam UserResolver userResolver, RestAccessTokenRequest restRequest) {
        return super.createAccessToken(userResolver.getUser(), restRequest);
    }

    @Operation(description="Get all access tokens associated with the given user.", summary="Get personal HTTP tokens")
    @ResponseDocs(value={@ResponseDoc(documentation="A response containing a page of access tokens and associated details.", paged=true, representation=RestAccessToken.class, responseCode=200), @ResponseDoc(documentation="The currently authenticated user is not permitted to get access tokens on behalf of this user or authentication failed.", responseCode=401, restError=true), @ResponseDoc(documentation="The specified user does not exist.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getAllAccessTokens(@BeanParam UserResolver userResolver, @BeanParam PageRequestResolver pageRequestResolver, @Context HttpServletRequest request) {
        ApplicationUser user = userResolver.getUser();
        this.enforceWebSudo(user, request);
        Page<AccessToken> accessTokens = this.getAllForEntity(user, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(accessTokens, RestAccessToken::new)).build();
    }

    @Override
    protected void deleteByIdChecks(String tokenId, HttpServletRequest request) {
        this.accessTokenService.getById(tokenId).ifPresent(token -> this.enforceWebSudo(token.getUser(), request));
    }

    @Override
    protected void getByIdChecks(AccessToken token, HttpServletRequest request) {
        this.enforceWebSudo(token.getUser(), request);
    }

    @Override
    protected void updateAccessTokenChecks(String tokenId, HttpServletRequest request) {
        this.accessTokenService.getById(tokenId).ifPresent(token -> this.enforceWebSudo(token.getUser(), request));
    }

    private void enforceWebSudo(ApplicationUser user, HttpServletRequest request) {
        if (this.authenticationContext.getCurrentUser() != null && user.getId() != this.authenticationContext.getCurrentUser().getId()) {
            this.webSudoManager.willExecuteWebSudoRequest(request);
        }
    }
}

