/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.network.ApplicationGateway;
import com.microsoft.azure.management.network.ApplicationGatewayAuthenticationCertificate;
import com.microsoft.azure.management.network.ApplicationGatewayBackendHttpSettings;
import com.microsoft.azure.management.network.ApplicationGatewayProbe;
import com.microsoft.azure.management.network.ApplicationGatewayProtocol;
import com.microsoft.azure.management.network.model.HasPort;
import com.microsoft.azure.management.network.model.HasProtocol;
import com.microsoft.azure.management.resources.fluentcore.arm.models.ChildResource;
import com.microsoft.azure.management.resources.fluentcore.model.Attachable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Settable;
import java.io.File;
import java.io.IOException;
import java.util.Map;

@Fluent
public interface ApplicationGatewayBackendHttpConfiguration
extends HasInner<ApplicationGatewayBackendHttpSettings>,
ChildResource<ApplicationGateway>,
HasProtocol<ApplicationGatewayProtocol>,
HasPort {
    @Beta(value=Beta.SinceVersion.V1_4_0)
    public Map<String, ApplicationGatewayAuthenticationCertificate> authenticationCertificates();

    public boolean cookieBasedAffinity();

    public int requestTimeout();

    public ApplicationGatewayProbe probe();

    @Beta(value=Beta.SinceVersion.V1_4_0)
    public String hostHeader();

    @Beta(value=Beta.SinceVersion.V1_4_0)
    public boolean isHostHeaderFromBackend();

    @Beta(value=Beta.SinceVersion.V1_4_0)
    public boolean isProbeEnabled();

    @Beta(value=Beta.SinceVersion.V1_4_0)
    public int connectionDrainingTimeoutInSeconds();

    @Beta(value=Beta.SinceVersion.V1_4_0)
    public String affinityCookieName();

    @Beta(value=Beta.SinceVersion.V1_4_0)
    public String path();

    public static interface UpdateDefinition<ReturnT>
    extends UpdateDefinitionStages.Blank<ReturnT>,
    UpdateDefinitionStages.WithAttach<ReturnT>,
    UpdateDefinitionStages.WithAttachAndAuthCert<ReturnT> {
    }

    public static interface UpdateDefinitionStages {

        public static interface WithConnectionDraining<ReturnT> {
            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithAttach<ReturnT> withConnectionDrainingTimeoutInSeconds(int var1);
        }

        public static interface WithHostHeader<ReturnT> {
            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithAttach<ReturnT> withHostHeader(String var1);

            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithAttach<ReturnT> withHostHeaderFromBackend();
        }

        public static interface WithProbe<ReturnT> {
            public WithAttach<ReturnT> withProbe(String var1);
        }

        public static interface WithPath<ReturnT> {
            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithAttach<ReturnT> withPath(String var1);
        }

        public static interface WithCookieName<ReturnT> {
            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithAttach<ReturnT> withAffinityCookieName(String var1);
        }

        public static interface WithAffinity<ReturnT> {
            @Method
            public WithAttach<ReturnT> withCookieBasedAffinity();

            @Method
            public WithAttach<ReturnT> withoutCookieBasedAffinity();
        }

        public static interface WithProtocol<ReturnT> {
            @Deprecated
            public WithAttach<ReturnT> withProtocol(ApplicationGatewayProtocol var1);

            @Method
            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithAttachAndAuthCert<ReturnT> withHttps();
        }

        public static interface WithRequestTimeout<ReturnT> {
            public WithAttach<ReturnT> withRequestTimeout(int var1);
        }

        public static interface WithPort<ReturnT>
        extends HasPort.UpdateDefinitionStages.WithPort<WithAttach<ReturnT>> {
        }

        public static interface WithAuthenticationCertificate<ReturnT> {
            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithAttachAndAuthCert<ReturnT> withAuthenticationCertificate(String var1);

            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithAttachAndAuthCert<ReturnT> withAuthenticationCertificateFromBytes(byte[] var1);

            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithAttachAndAuthCert<ReturnT> withAuthenticationCertificateFromFile(File var1) throws IOException;

            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithAttachAndAuthCert<ReturnT> withAuthenticationCertificateFromBase64(String var1);
        }

        public static interface WithAttach<ReturnT>
        extends Attachable.InUpdate<ReturnT>,
        WithPort<ReturnT>,
        WithAffinity<ReturnT>,
        WithProtocol<ReturnT>,
        WithRequestTimeout<ReturnT>,
        WithHostHeader<ReturnT>,
        WithConnectionDraining<ReturnT>,
        WithCookieName<ReturnT>,
        WithPath<ReturnT>,
        WithAuthenticationCertificate<ReturnT> {
        }

        public static interface WithAttachAndAuthCert<ReturnT>
        extends WithAttach<ReturnT>,
        WithAuthenticationCertificate<ReturnT> {
        }

        public static interface Blank<ReturnT>
        extends WithAttach<ReturnT> {
        }
    }

    public static interface Update
    extends Settable<ApplicationGateway.Update>,
    UpdateStages.WithPort,
    UpdateStages.WithAffinity,
    UpdateStages.WithProtocol,
    UpdateStages.WithRequestTimeout,
    UpdateStages.WithProbe,
    UpdateStages.WithHostHeader,
    UpdateStages.WithConnectionDraining,
    UpdateStages.WithCookieName,
    UpdateStages.WithPath,
    UpdateStages.WithAuthenticationCertificate {
    }

    public static interface UpdateStages {

        public static interface WithAuthenticationCertificate {
            @Beta(value=Beta.SinceVersion.V1_4_0)
            public Update withAuthenticationCertificate(String var1);

            @Beta(value=Beta.SinceVersion.V1_4_0)
            public Update withAuthenticationCertificateFromBytes(byte[] var1);

            @Beta(value=Beta.SinceVersion.V1_4_0)
            public Update withAuthenticationCertificateFromFile(File var1) throws IOException;

            @Beta(value=Beta.SinceVersion.V1_4_0)
            public Update withAuthenticationCertificateFromBase64(String var1);

            @Beta(value=Beta.SinceVersion.V1_4_0)
            public Update withoutAuthenticationCertificate(String var1);

            @Beta(value=Beta.SinceVersion.V1_4_0)
            @Method
            public Update withoutAuthenticationCertificates();
        }

        public static interface WithPath {
            @Beta(value=Beta.SinceVersion.V1_4_0)
            public Update withPath(String var1);
        }

        public static interface WithCookieName {
            @Beta(value=Beta.SinceVersion.V1_4_0)
            public Update withAffinityCookieName(String var1);
        }

        public static interface WithConnectionDraining {
            @Beta(value=Beta.SinceVersion.V1_4_0)
            public Update withConnectionDrainingTimeoutInSeconds(int var1);

            @Beta(value=Beta.SinceVersion.V1_4_0)
            public Update withoutConnectionDraining();
        }

        public static interface WithHostHeader {
            @Beta(value=Beta.SinceVersion.V1_4_0)
            public Update withHostHeaderFromBackend();

            @Beta(value=Beta.SinceVersion.V1_4_0)
            public Update withoutHostHeader();

            @Beta(value=Beta.SinceVersion.V1_4_0)
            public Update withHostHeader(String var1);
        }

        public static interface WithProbe {
            public Update withProbe(String var1);

            @Method
            public Update withoutProbe();
        }

        public static interface WithRequestTimeout {
            public Update withRequestTimeout(int var1);
        }

        public static interface WithProtocol {
            @Deprecated
            public Update withProtocol(ApplicationGatewayProtocol var1);

            @Method
            @Beta(value=Beta.SinceVersion.V1_4_0)
            public Update withHttps();

            @Method
            @Beta(value=Beta.SinceVersion.V1_4_0)
            public Update withHttp();
        }

        public static interface WithAffinity {
            @Method
            public Update withCookieBasedAffinity();

            @Method
            public Update withoutCookieBasedAffinity();
        }

        public static interface WithPort
        extends HasPort.UpdateStages.WithPort<Update> {
        }
    }

    public static interface Definition<ReturnT>
    extends DefinitionStages.Blank<ReturnT>,
    DefinitionStages.WithAttach<ReturnT>,
    DefinitionStages.WithAttachAndAuthCert<ReturnT> {
    }

    public static interface DefinitionStages {

        public static interface WithAttach<ReturnT>
        extends Attachable.InDefinition<ReturnT>,
        WithPort<ReturnT>,
        WithAffinity<ReturnT>,
        WithProtocol<ReturnT>,
        WithRequestTimeout<ReturnT>,
        WithProbe<ReturnT>,
        WithHostHeader<ReturnT>,
        WithConnectionDraining<ReturnT>,
        WithCookieName<ReturnT>,
        WithPath<ReturnT> {
        }

        public static interface WithAttachAndAuthCert<ReturnT>
        extends WithAttach<ReturnT>,
        WithAuthenticationCertificate<ReturnT> {
        }

        public static interface WithAuthenticationCertificate<ReturnT> {
            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithAttachAndAuthCert<ReturnT> withAuthenticationCertificate(String var1);

            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithAttachAndAuthCert<ReturnT> withAuthenticationCertificateFromBytes(byte[] var1);

            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithAttachAndAuthCert<ReturnT> withAuthenticationCertificateFromFile(File var1) throws IOException;

            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithAttachAndAuthCert<ReturnT> withAuthenticationCertificateFromBase64(String var1);
        }

        public static interface WithConnectionDraining<ReturnT> {
            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithAttach<ReturnT> withConnectionDrainingTimeoutInSeconds(int var1);
        }

        public static interface WithHostHeader<ReturnT> {
            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithAttach<ReturnT> withHostHeaderFromBackend();

            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithAttach<ReturnT> withHostHeader(String var1);
        }

        public static interface WithProbe<ReturnT> {
            public WithAttach<ReturnT> withProbe(String var1);
        }

        public static interface WithRequestTimeout<ReturnT> {
            public WithAttach<ReturnT> withRequestTimeout(int var1);
        }

        public static interface WithPath<ReturnT> {
            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithAttach<ReturnT> withPath(String var1);
        }

        public static interface WithCookieName<ReturnT> {
            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithAttach<ReturnT> withAffinityCookieName(String var1);
        }

        public static interface WithAffinity<ReturnT> {
            @Method
            public WithAttach<ReturnT> withCookieBasedAffinity();
        }

        public static interface WithProtocol<ReturnT> {
            @Deprecated
            public WithAttach<ReturnT> withProtocol(ApplicationGatewayProtocol var1);

            @Method
            @Beta(value=Beta.SinceVersion.V1_4_0)
            public WithAttachAndAuthCert<ReturnT> withHttps();
        }

        public static interface WithPort<ReturnT>
        extends HasPort.DefinitionStages.WithPort<WithAttach<ReturnT>> {
        }

        public static interface Blank<ReturnT>
        extends WithAttach<ReturnT> {
        }
    }
}

