/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.AvailableServiceAliasInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class AvailableServiceAliasesInner {
    private AvailableServiceAliasesService service;
    private NetworkManagementClientImpl client;

    public AvailableServiceAliasesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (AvailableServiceAliasesService)retrofit.create(AvailableServiceAliasesService.class);
        this.client = client;
    }

    public PagedList<AvailableServiceAliasInner> list(String location) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(location).toBlocking().single();
        return new PagedList<AvailableServiceAliasInner>((Page)response.body()){

            public Page<AvailableServiceAliasInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AvailableServiceAliasesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AvailableServiceAliasInner>> listAsync(String location, ListOperationCallback<AvailableServiceAliasInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(location), (Func1)new Func1<String, Observable<ServiceResponse<Page<AvailableServiceAliasInner>>>>(){

            public Observable<ServiceResponse<Page<AvailableServiceAliasInner>>> call(String nextPageLink) {
                return AvailableServiceAliasesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AvailableServiceAliasInner>> listAsync(String location) {
        return this.listWithServiceResponseAsync(location).map((Func1)new Func1<ServiceResponse<Page<AvailableServiceAliasInner>>, Page<AvailableServiceAliasInner>>(){

            public Page<AvailableServiceAliasInner> call(ServiceResponse<Page<AvailableServiceAliasInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AvailableServiceAliasInner>>> listWithServiceResponseAsync(String location) {
        return this.listSinglePageAsync(location).concatMap((Func1)new Func1<ServiceResponse<Page<AvailableServiceAliasInner>>, Observable<ServiceResponse<Page<AvailableServiceAliasInner>>>>(){

            public Observable<ServiceResponse<Page<AvailableServiceAliasInner>>> call(ServiceResponse<Page<AvailableServiceAliasInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AvailableServiceAliasesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AvailableServiceAliasInner>>> listSinglePageAsync(String location) {
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(location, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AvailableServiceAliasInner>>>>(){

            public Observable<ServiceResponse<Page<AvailableServiceAliasInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AvailableServiceAliasesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AvailableServiceAliasInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AvailableServiceAliasInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<AvailableServiceAliasInner> listByResourceGroup(String resourceGroupName, String location) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName, location).toBlocking().single();
        return new PagedList<AvailableServiceAliasInner>((Page)response.body()){

            public Page<AvailableServiceAliasInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AvailableServiceAliasesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AvailableServiceAliasInner>> listByResourceGroupAsync(String resourceGroupName, String location, ListOperationCallback<AvailableServiceAliasInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName, location), (Func1)new Func1<String, Observable<ServiceResponse<Page<AvailableServiceAliasInner>>>>(){

            public Observable<ServiceResponse<Page<AvailableServiceAliasInner>>> call(String nextPageLink) {
                return AvailableServiceAliasesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AvailableServiceAliasInner>> listByResourceGroupAsync(String resourceGroupName, String location) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, location).map((Func1)new Func1<ServiceResponse<Page<AvailableServiceAliasInner>>, Page<AvailableServiceAliasInner>>(){

            public Page<AvailableServiceAliasInner> call(ServiceResponse<Page<AvailableServiceAliasInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AvailableServiceAliasInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, String location) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName, location).concatMap((Func1)new Func1<ServiceResponse<Page<AvailableServiceAliasInner>>, Observable<ServiceResponse<Page<AvailableServiceAliasInner>>>>(){

            public Observable<ServiceResponse<Page<AvailableServiceAliasInner>>> call(ServiceResponse<Page<AvailableServiceAliasInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AvailableServiceAliasesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AvailableServiceAliasInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName, String location) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (location == null) {
            throw new IllegalArgumentException("Parameter location is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.listByResourceGroup(resourceGroupName, location, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AvailableServiceAliasInner>>>>(){

            public Observable<ServiceResponse<Page<AvailableServiceAliasInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AvailableServiceAliasesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AvailableServiceAliasInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AvailableServiceAliasInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<AvailableServiceAliasInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AvailableServiceAliasInner>((Page)response.body()){

            public Page<AvailableServiceAliasInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AvailableServiceAliasesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AvailableServiceAliasInner>> listNextAsync(String nextPageLink, ServiceFuture<List<AvailableServiceAliasInner>> serviceFuture, ListOperationCallback<AvailableServiceAliasInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<AvailableServiceAliasInner>>>>(){

            public Observable<ServiceResponse<Page<AvailableServiceAliasInner>>> call(String nextPageLink) {
                return AvailableServiceAliasesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AvailableServiceAliasInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<AvailableServiceAliasInner>>, Page<AvailableServiceAliasInner>>(){

            public Page<AvailableServiceAliasInner> call(ServiceResponse<Page<AvailableServiceAliasInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AvailableServiceAliasInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<AvailableServiceAliasInner>>, Observable<ServiceResponse<Page<AvailableServiceAliasInner>>>>(){

            public Observable<ServiceResponse<Page<AvailableServiceAliasInner>>> call(ServiceResponse<Page<AvailableServiceAliasInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AvailableServiceAliasesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AvailableServiceAliasInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AvailableServiceAliasInner>>>>(){

            public Observable<ServiceResponse<Page<AvailableServiceAliasInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AvailableServiceAliasesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AvailableServiceAliasInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AvailableServiceAliasInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<AvailableServiceAliasInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<AvailableServiceAliasInner>((Page)response.body()){

            public Page<AvailableServiceAliasInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)AvailableServiceAliasesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<AvailableServiceAliasInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<AvailableServiceAliasInner>> serviceFuture, ListOperationCallback<AvailableServiceAliasInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<AvailableServiceAliasInner>>>>(){

            public Observable<ServiceResponse<Page<AvailableServiceAliasInner>>> call(String nextPageLink) {
                return AvailableServiceAliasesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<AvailableServiceAliasInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<AvailableServiceAliasInner>>, Page<AvailableServiceAliasInner>>(){

            public Page<AvailableServiceAliasInner> call(ServiceResponse<Page<AvailableServiceAliasInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<AvailableServiceAliasInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<AvailableServiceAliasInner>>, Observable<ServiceResponse<Page<AvailableServiceAliasInner>>>>(){

            public Observable<ServiceResponse<Page<AvailableServiceAliasInner>>> call(ServiceResponse<Page<AvailableServiceAliasInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(AvailableServiceAliasesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<AvailableServiceAliasInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<AvailableServiceAliasInner>>>>(){

            public Observable<ServiceResponse<Page<AvailableServiceAliasInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = AvailableServiceAliasesInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<AvailableServiceAliasInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<AvailableServiceAliasInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface AvailableServiceAliasesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.AvailableServiceAliases list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/locations/{location}/availableServiceAliases")
        public Observable<Response<ResponseBody>> list(@Path(value="location") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.AvailableServiceAliases listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/locations/{location}/availableServiceAliases")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="location") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.AvailableServiceAliases listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.AvailableServiceAliases listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

