/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ConnectionMonitor;
import com.microsoft.azure.management.network.ConnectionMonitorDestination;
import com.microsoft.azure.management.network.ConnectionMonitorQueryResult;
import com.microsoft.azure.management.network.ConnectionMonitorSource;
import com.microsoft.azure.management.network.NetworkWatcher;
import com.microsoft.azure.management.network.ProvisioningState;
import com.microsoft.azure.management.network.implementation.ConnectionMonitorInner;
import com.microsoft.azure.management.network.implementation.ConnectionMonitorQueryResultImpl;
import com.microsoft.azure.management.network.implementation.ConnectionMonitorQueryResultInner;
import com.microsoft.azure.management.network.implementation.ConnectionMonitorResultInner;
import com.microsoft.azure.management.network.implementation.ConnectionMonitorsInner;
import com.microsoft.azure.management.network.implementation.NetworkWatcherImpl;
import com.microsoft.azure.management.network.model.HasNetworkInterfaces;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.joda.time.DateTime;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
public class ConnectionMonitorImpl
extends CreatableUpdatableImpl<ConnectionMonitor, ConnectionMonitorResultInner, ConnectionMonitorImpl>
implements ConnectionMonitor,
ConnectionMonitor.Definition {
    private final ConnectionMonitorsInner client;
    private final ConnectionMonitorInner createParameters;
    private final NetworkWatcher parent;

    ConnectionMonitorImpl(String name, NetworkWatcherImpl parent, ConnectionMonitorResultInner innerObject, ConnectionMonitorsInner client) {
        super(name, (Object)innerObject);
        this.client = client;
        this.parent = parent;
        this.createParameters = new ConnectionMonitorInner().withLocation(parent.regionName());
    }

    protected Observable<ConnectionMonitorResultInner> getInnerAsync() {
        return this.client.getAsync(this.parent.resourceGroupName(), this.parent.name(), this.name());
    }

    @Override
    public String location() {
        return ((ConnectionMonitorResultInner)((Object)this.inner())).location();
    }

    @Override
    public Map<String, String> tags() {
        TreeMap tags = ((ConnectionMonitorResultInner)((Object)this.inner())).getTags();
        if (tags == null) {
            tags = new TreeMap();
        }
        return Collections.unmodifiableMap(tags);
    }

    @Override
    public ConnectionMonitorSource source() {
        return ((ConnectionMonitorResultInner)((Object)this.inner())).source();
    }

    @Override
    public ConnectionMonitorDestination destination() {
        return ((ConnectionMonitorResultInner)((Object)this.inner())).destination();
    }

    @Override
    public boolean autoStart() {
        return Utils.toPrimitiveBoolean((Boolean)((ConnectionMonitorResultInner)((Object)this.inner())).autoStart());
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((ConnectionMonitorResultInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public DateTime startTime() {
        return ((ConnectionMonitorResultInner)((Object)this.inner())).startTime();
    }

    @Override
    public String monitoringStatus() {
        return ((ConnectionMonitorResultInner)((Object)this.inner())).monitoringStatus();
    }

    @Override
    public int monitoringIntervalInSeconds() {
        return Utils.toPrimitiveInt((Integer)((ConnectionMonitorResultInner)((Object)this.inner())).monitoringIntervalInSeconds());
    }

    @Override
    public void stop() {
        this.stopAsync().await();
    }

    @Override
    public Completable stopAsync() {
        return this.client.stopAsync(this.parent.resourceGroupName(), this.parent.name(), this.name()).flatMap(new Func1<Void, Observable<?>>(){

            public Observable<?> call(Void aVoid) {
                return ConnectionMonitorImpl.this.refreshAsync();
            }
        }).toCompletable();
    }

    @Override
    public void start() {
        this.startAsync().await();
    }

    @Override
    public Completable startAsync() {
        return this.client.startAsync(this.parent.resourceGroupName(), this.parent.name(), this.name()).flatMap(new Func1<Void, Observable<?>>(){

            public Observable<?> call(Void aVoid) {
                return ConnectionMonitorImpl.this.refreshAsync();
            }
        }).toCompletable();
    }

    @Override
    public ConnectionMonitorQueryResult query() {
        return (ConnectionMonitorQueryResult)this.queryAsync().toBlocking().last();
    }

    @Override
    public Observable<ConnectionMonitorQueryResult> queryAsync() {
        return this.client.queryAsync(this.parent.resourceGroupName(), this.parent.name(), this.name()).map((Func1)new Func1<ConnectionMonitorQueryResultInner, ConnectionMonitorQueryResult>(){

            public ConnectionMonitorQueryResult call(ConnectionMonitorQueryResultInner inner) {
                return new ConnectionMonitorQueryResultImpl(inner);
            }
        });
    }

    public boolean isInCreateMode() {
        return ((ConnectionMonitorResultInner)((Object)this.inner())).id() == null;
    }

    public Observable<ConnectionMonitor> createResourceAsync() {
        return this.client.createOrUpdateAsync(this.parent.resourceGroupName(), this.parent.name(), this.name(), this.createParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public String id() {
        return ((ConnectionMonitorResultInner)((Object)this.inner())).id();
    }

    @Override
    public ConnectionMonitorImpl withSourceId(String resourceId) {
        this.ensureConnectionMonitorSource().withResourceId(resourceId);
        return this;
    }

    @Override
    public ConnectionMonitorImpl withSource(HasNetworkInterfaces vm) {
        this.ensureConnectionMonitorSource().withResourceId(vm.id());
        return this;
    }

    @Override
    public ConnectionMonitorImpl withDestinationId(String resourceId) {
        this.ensureConnectionMonitorDestination().withResourceId(resourceId);
        return this;
    }

    @Override
    public ConnectionMonitorImpl withDestination(HasNetworkInterfaces vm) {
        this.ensureConnectionMonitorDestination().withResourceId(vm.id());
        return this;
    }

    @Override
    public ConnectionMonitor.DefinitionStages.WithDestinationPort withDestinationAddress(String address) {
        this.ensureConnectionMonitorDestination().withAddress(address);
        return this;
    }

    private ConnectionMonitorSource ensureConnectionMonitorSource() {
        if (this.createParameters.source() == null) {
            this.createParameters.withSource(new ConnectionMonitorSource());
        }
        return this.createParameters.source();
    }

    private ConnectionMonitorDestination ensureConnectionMonitorDestination() {
        if (this.createParameters.destination() == null) {
            this.createParameters.withDestination(new ConnectionMonitorDestination());
        }
        return this.createParameters.destination();
    }

    @Override
    public ConnectionMonitorImpl withDestinationPort(int port) {
        this.ensureConnectionMonitorDestination().withPort(port);
        return this;
    }

    @Override
    public ConnectionMonitorImpl withSourcePort(int port) {
        this.ensureConnectionMonitorSource().withPort(port);
        return this;
    }

    @Override
    public ConnectionMonitorImpl withoutAutoStart() {
        this.createParameters.withAutoStart(false);
        return this;
    }

    @Override
    public final ConnectionMonitorImpl withTags(Map<String, String> tags) {
        this.createParameters.withTags(new HashMap<String, String>(tags));
        return this;
    }

    @Override
    public ConnectionMonitorImpl withTag(String key, String value) {
        if (this.createParameters.tags() == null) {
            this.createParameters.withTags(new HashMap<String, String>());
        }
        this.createParameters.tags().put(key, value);
        return this;
    }

    @Override
    public ConnectionMonitorImpl withoutTag(String key) {
        if (this.createParameters.tags() != null) {
            this.createParameters.tags().remove(key);
        }
        return this;
    }

    @Override
    public ConnectionMonitorImpl withMonitoringInterval(int seconds) {
        this.createParameters.withMonitoringIntervalInSeconds(seconds);
        return this;
    }
}

