/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ExpressRouteCircuit;
import com.microsoft.azure.management.network.ExpressRouteCircuitPeering;
import com.microsoft.azure.management.network.ExpressRouteCircuitPeeringConfig;
import com.microsoft.azure.management.network.ExpressRoutePeeringState;
import com.microsoft.azure.management.network.ExpressRoutePeeringType;
import com.microsoft.azure.management.network.Ipv6ExpressRouteCircuitPeeringConfig;
import com.microsoft.azure.management.network.ProvisioningState;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitImpl;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitPeeringInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitPeeringsInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitStatsImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.CreatableUpdatableImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.Arrays;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class ExpressRouteCircuitPeeringImpl
extends CreatableUpdatableImpl<ExpressRouteCircuitPeering, ExpressRouteCircuitPeeringInner, ExpressRouteCircuitPeeringImpl>
implements ExpressRouteCircuitPeering,
ExpressRouteCircuitPeering.Definition,
ExpressRouteCircuitPeering.Update {
    private final ExpressRouteCircuitPeeringsInner client;
    private final ExpressRouteCircuit parent;
    private ExpressRouteCircuitStatsImpl stats;

    ExpressRouteCircuitPeeringImpl(ExpressRouteCircuitImpl parent, ExpressRouteCircuitPeeringInner innerObject, ExpressRouteCircuitPeeringsInner client, ExpressRoutePeeringType type) {
        super(type.toString(), (Object)innerObject);
        this.client = client;
        this.parent = parent;
        this.stats = new ExpressRouteCircuitStatsImpl(innerObject.stats());
        ((ExpressRouteCircuitPeeringInner)((Object)this.inner())).withPeeringType(type);
    }

    @Override
    public ExpressRouteCircuitPeeringImpl withAdvertisedPublicPrefixes(String publicPrefix) {
        this.ensureMicrosoftPeeringConfig().withAdvertisedPublicPrefixes(Arrays.asList(publicPrefix));
        return this;
    }

    private ExpressRouteCircuitPeeringConfig ensureMicrosoftPeeringConfig() {
        if (((ExpressRouteCircuitPeeringInner)((Object)this.inner())).microsoftPeeringConfig() == null) {
            ((ExpressRouteCircuitPeeringInner)((Object)this.inner())).withMicrosoftPeeringConfig(new ExpressRouteCircuitPeeringConfig());
        }
        return ((ExpressRouteCircuitPeeringInner)((Object)this.inner())).microsoftPeeringConfig();
    }

    @Override
    public ExpressRouteCircuitPeeringImpl withPrimaryPeerAddressPrefix(String addressPrefix) {
        ((ExpressRouteCircuitPeeringInner)((Object)this.inner())).withPrimaryPeerAddressPrefix(addressPrefix);
        return this;
    }

    @Override
    public ExpressRouteCircuitPeeringImpl withSecondaryPeerAddressPrefix(String addressPrefix) {
        ((ExpressRouteCircuitPeeringInner)((Object)this.inner())).withSecondaryPeerAddressPrefix(addressPrefix);
        return this;
    }

    @Override
    public ExpressRouteCircuitPeeringImpl withVlanId(int vlanId) {
        ((ExpressRouteCircuitPeeringInner)((Object)this.inner())).withVlanId(vlanId);
        return this;
    }

    @Override
    public ExpressRouteCircuitPeeringImpl withPeerAsn(long peerAsn) {
        ((ExpressRouteCircuitPeeringInner)((Object)this.inner())).withPeerASN(peerAsn);
        return this;
    }

    protected Observable<ExpressRouteCircuitPeeringInner> getInnerAsync() {
        return this.client.getAsync(this.parent.resourceGroupName(), this.parent.name(), this.name());
    }

    public boolean isInCreateMode() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.inner())).id() == null;
    }

    public Observable<ExpressRouteCircuitPeering> createResourceAsync() {
        return this.client.createOrUpdateAsync(this.parent.resourceGroupName(), this.parent.name(), this.name(), (ExpressRouteCircuitPeeringInner)((Object)this.inner())).map((Func1)new Func1<ExpressRouteCircuitPeeringInner, ExpressRouteCircuitPeering>(){

            public ExpressRouteCircuitPeering call(ExpressRouteCircuitPeeringInner innerModel) {
                ExpressRouteCircuitPeeringImpl.this.setInner((Object)innerModel);
                ExpressRouteCircuitPeeringImpl.this.stats = new ExpressRouteCircuitStatsImpl(innerModel.stats());
                ExpressRouteCircuitPeeringImpl.this.parent.refresh();
                return ExpressRouteCircuitPeeringImpl.this;
            }
        });
    }

    public String id() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.inner())).id();
    }

    @Override
    public ExpressRoutePeeringType peeringType() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.inner())).peeringType();
    }

    @Override
    public ExpressRoutePeeringState state() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.inner())).state();
    }

    @Override
    public int azureAsn() {
        return Utils.toPrimitiveInt((Integer)((ExpressRouteCircuitPeeringInner)((Object)this.inner())).azureASN());
    }

    @Override
    public long peerAsn() {
        return Utils.toPrimitiveInt((Long)((ExpressRouteCircuitPeeringInner)((Object)this.inner())).peerASN());
    }

    @Override
    public String primaryPeerAddressPrefix() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.inner())).primaryPeerAddressPrefix();
    }

    @Override
    public String secondaryPeerAddressPrefix() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.inner())).secondaryPeerAddressPrefix();
    }

    @Override
    public String primaryAzurePort() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.inner())).primaryAzurePort();
    }

    @Override
    public String secondaryAzurePort() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.inner())).secondaryAzurePort();
    }

    @Override
    public String sharedKey() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.inner())).sharedKey();
    }

    @Override
    public int vlanId() {
        return Utils.toPrimitiveInt((Integer)((ExpressRouteCircuitPeeringInner)((Object)this.inner())).vlanId());
    }

    @Override
    public ExpressRouteCircuitPeeringConfig microsoftPeeringConfig() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.inner())).microsoftPeeringConfig();
    }

    @Override
    public ExpressRouteCircuitStatsImpl stats() {
        return this.stats;
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public String lastModifiedBy() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.inner())).lastModifiedBy();
    }

    @Override
    public Ipv6ExpressRouteCircuitPeeringConfig ipv6PeeringConfig() {
        return ((ExpressRouteCircuitPeeringInner)((Object)this.inner())).ipv6PeeringConfig();
    }

    public NetworkManager manager() {
        return (NetworkManager)((Object)this.parent.manager());
    }

    public String resourceGroupName() {
        return this.parent.resourceGroupName();
    }
}

