/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.implementation.FirewallPolicyInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class FirewallPoliciesInner
implements InnerSupportsGet<FirewallPolicyInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<FirewallPolicyInner> {
    private FirewallPoliciesService service;
    private NetworkManagementClientImpl client;

    public FirewallPoliciesInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (FirewallPoliciesService)retrofit.create(FirewallPoliciesService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String firewallPolicyName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, firewallPolicyName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String firewallPolicyName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, firewallPolicyName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String firewallPolicyName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, firewallPolicyName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String firewallPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (firewallPolicyName == null) {
            throw new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, firewallPolicyName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String firewallPolicyName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, firewallPolicyName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String firewallPolicyName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, firewallPolicyName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String firewallPolicyName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, firewallPolicyName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String firewallPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (firewallPolicyName == null) {
            throw new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginDelete(resourceGroupName, firewallPolicyName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FirewallPoliciesInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public FirewallPolicyInner getByResourceGroup(String resourceGroupName, String firewallPolicyName) {
        return (FirewallPolicyInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, firewallPolicyName).toBlocking().single()).body());
    }

    public ServiceFuture<FirewallPolicyInner> getByResourceGroupAsync(String resourceGroupName, String firewallPolicyName, ServiceCallback<FirewallPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, firewallPolicyName), serviceCallback);
    }

    public Observable<FirewallPolicyInner> getByResourceGroupAsync(String resourceGroupName, String firewallPolicyName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, firewallPolicyName).map((Func1)new Func1<ServiceResponse<FirewallPolicyInner>, FirewallPolicyInner>(){

            public FirewallPolicyInner call(ServiceResponse<FirewallPolicyInner> response) {
                return (FirewallPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FirewallPolicyInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String firewallPolicyName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (firewallPolicyName == null) {
            throw new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        String expand = null;
        return this.service.getByResourceGroup(resourceGroupName, firewallPolicyName, this.client.subscriptionId(), "2019-11-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FirewallPolicyInner>>>(){

            public Observable<ServiceResponse<FirewallPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FirewallPoliciesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public FirewallPolicyInner getByResourceGroup(String resourceGroupName, String firewallPolicyName, String expand) {
        return (FirewallPolicyInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, firewallPolicyName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<FirewallPolicyInner> getByResourceGroupAsync(String resourceGroupName, String firewallPolicyName, String expand, ServiceCallback<FirewallPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, firewallPolicyName, expand), serviceCallback);
    }

    public Observable<FirewallPolicyInner> getByResourceGroupAsync(String resourceGroupName, String firewallPolicyName, String expand) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, firewallPolicyName, expand).map((Func1)new Func1<ServiceResponse<FirewallPolicyInner>, FirewallPolicyInner>(){

            public FirewallPolicyInner call(ServiceResponse<FirewallPolicyInner> response) {
                return (FirewallPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FirewallPolicyInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String firewallPolicyName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (firewallPolicyName == null) {
            throw new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.getByResourceGroup(resourceGroupName, firewallPolicyName, this.client.subscriptionId(), "2019-11-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FirewallPolicyInner>>>(){

            public Observable<ServiceResponse<FirewallPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FirewallPoliciesInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FirewallPolicyInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FirewallPolicyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public FirewallPolicyInner createOrUpdate(String resourceGroupName, String firewallPolicyName, FirewallPolicyInner parameters) {
        return (FirewallPolicyInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, firewallPolicyName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<FirewallPolicyInner> createOrUpdateAsync(String resourceGroupName, String firewallPolicyName, FirewallPolicyInner parameters, ServiceCallback<FirewallPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, firewallPolicyName, parameters), serviceCallback);
    }

    public Observable<FirewallPolicyInner> createOrUpdateAsync(String resourceGroupName, String firewallPolicyName, FirewallPolicyInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, firewallPolicyName, parameters).map((Func1)new Func1<ServiceResponse<FirewallPolicyInner>, FirewallPolicyInner>(){

            public FirewallPolicyInner call(ServiceResponse<FirewallPolicyInner> response) {
                return (FirewallPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FirewallPolicyInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String firewallPolicyName, FirewallPolicyInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (firewallPolicyName == null) {
            throw new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, firewallPolicyName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<FirewallPolicyInner>(){}.getType());
    }

    public FirewallPolicyInner beginCreateOrUpdate(String resourceGroupName, String firewallPolicyName, FirewallPolicyInner parameters) {
        return (FirewallPolicyInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, firewallPolicyName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<FirewallPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String firewallPolicyName, FirewallPolicyInner parameters, ServiceCallback<FirewallPolicyInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, firewallPolicyName, parameters), serviceCallback);
    }

    public Observable<FirewallPolicyInner> beginCreateOrUpdateAsync(String resourceGroupName, String firewallPolicyName, FirewallPolicyInner parameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, firewallPolicyName, parameters).map((Func1)new Func1<ServiceResponse<FirewallPolicyInner>, FirewallPolicyInner>(){

            public FirewallPolicyInner call(ServiceResponse<FirewallPolicyInner> response) {
                return (FirewallPolicyInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FirewallPolicyInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String firewallPolicyName, FirewallPolicyInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (firewallPolicyName == null) {
            throw new IllegalArgumentException("Parameter firewallPolicyName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        String apiVersion = "2019-11-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, firewallPolicyName, this.client.subscriptionId(), parameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FirewallPolicyInner>>>(){

            public Observable<ServiceResponse<FirewallPolicyInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FirewallPoliciesInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FirewallPolicyInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FirewallPolicyInner>(){}.getType()).register(201, new TypeToken<FirewallPolicyInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<FirewallPolicyInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<FirewallPolicyInner>((Page)response.body()){

            public Page<FirewallPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FirewallPoliciesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FirewallPolicyInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<FirewallPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<FirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<FirewallPolicyInner>>> call(String nextPageLink) {
                return FirewallPoliciesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FirewallPolicyInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<FirewallPolicyInner>>, Page<FirewallPolicyInner>>(){

            public Page<FirewallPolicyInner> call(ServiceResponse<Page<FirewallPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FirewallPolicyInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<FirewallPolicyInner>>, Observable<ServiceResponse<Page<FirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<FirewallPolicyInner>>> call(ServiceResponse<Page<FirewallPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FirewallPoliciesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FirewallPolicyInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<FirewallPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FirewallPoliciesInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FirewallPolicyInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<FirewallPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<FirewallPolicyInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<FirewallPolicyInner>((Page)response.body()){

            public Page<FirewallPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FirewallPoliciesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FirewallPolicyInner>> listAsync(ListOperationCallback<FirewallPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<FirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<FirewallPolicyInner>>> call(String nextPageLink) {
                return FirewallPoliciesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FirewallPolicyInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<FirewallPolicyInner>>, Page<FirewallPolicyInner>>(){

            public Page<FirewallPolicyInner> call(ServiceResponse<Page<FirewallPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FirewallPolicyInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<FirewallPolicyInner>>, Observable<ServiceResponse<Page<FirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<FirewallPolicyInner>>> call(ServiceResponse<Page<FirewallPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FirewallPoliciesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FirewallPolicyInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<FirewallPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FirewallPoliciesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FirewallPolicyInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<FirewallPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<FirewallPolicyInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<FirewallPolicyInner>((Page)response.body()){

            public Page<FirewallPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FirewallPoliciesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FirewallPolicyInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<FirewallPolicyInner>> serviceFuture, ListOperationCallback<FirewallPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<FirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<FirewallPolicyInner>>> call(String nextPageLink) {
                return FirewallPoliciesInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FirewallPolicyInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<FirewallPolicyInner>>, Page<FirewallPolicyInner>>(){

            public Page<FirewallPolicyInner> call(ServiceResponse<Page<FirewallPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FirewallPolicyInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<FirewallPolicyInner>>, Observable<ServiceResponse<Page<FirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<FirewallPolicyInner>>> call(ServiceResponse<Page<FirewallPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FirewallPoliciesInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FirewallPolicyInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<FirewallPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FirewallPoliciesInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FirewallPolicyInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<FirewallPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<FirewallPolicyInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<FirewallPolicyInner>((Page)response.body()){

            public Page<FirewallPolicyInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FirewallPoliciesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FirewallPolicyInner>> listNextAsync(String nextPageLink, ServiceFuture<List<FirewallPolicyInner>> serviceFuture, ListOperationCallback<FirewallPolicyInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<FirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<FirewallPolicyInner>>> call(String nextPageLink) {
                return FirewallPoliciesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FirewallPolicyInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<FirewallPolicyInner>>, Page<FirewallPolicyInner>>(){

            public Page<FirewallPolicyInner> call(ServiceResponse<Page<FirewallPolicyInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FirewallPolicyInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<FirewallPolicyInner>>, Observable<ServiceResponse<Page<FirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<FirewallPolicyInner>>> call(ServiceResponse<Page<FirewallPolicyInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FirewallPoliciesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FirewallPolicyInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FirewallPolicyInner>>>>(){

            public Observable<ServiceResponse<Page<FirewallPolicyInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FirewallPoliciesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FirewallPolicyInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<FirewallPolicyInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface FirewallPoliciesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FirewallPolicies delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="firewallPolicyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FirewallPolicies beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="firewallPolicyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FirewallPolicies getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="firewallPolicyName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Query(value="$expand") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FirewallPolicies createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="firewallPolicyName") String var2, @Path(value="subscriptionId") String var3, @Body FirewallPolicyInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FirewallPolicies beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies/{firewallPolicyName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="firewallPolicyName") String var2, @Path(value="subscriptionId") String var3, @Body FirewallPolicyInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FirewallPolicies listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/firewallPolicies")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FirewallPolicies list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/firewallPolicies")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FirewallPolicies listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.FirewallPolicies listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

