/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.NetworkUsage;
import com.microsoft.azure.management.network.NetworkUsages;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkUsageImpl;
import com.microsoft.azure.management.network.implementation.UsageInner;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import rx.Observable;

class NetworkUsagesImpl
extends ReadableWrappersImpl<NetworkUsage, NetworkUsageImpl, UsageInner>
implements NetworkUsages {
    private final NetworkManagementClientImpl client;

    NetworkUsagesImpl(NetworkManagementClientImpl client) {
        this.client = client;
    }

    public PagedList<NetworkUsage> listByRegion(Region region) {
        return this.listByRegion(region.name());
    }

    public PagedList<NetworkUsage> listByRegion(String regionName) {
        return this.wrapList(this.client.usages().list(regionName));
    }

    public Observable<NetworkUsage> listByRegionAsync(Region region) {
        return this.listByRegionAsync(region.name());
    }

    public Observable<NetworkUsage> listByRegionAsync(String regionName) {
        return this.wrapPageAsync(this.client.usages().listAsync(regionName));
    }

    protected NetworkUsageImpl wrapModel(UsageInner usageInner) {
        if (usageInner == null) {
            return null;
        }
        return new NetworkUsageImpl(usageInner);
    }
}

