/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.LongRunningFinalState;
import com.microsoft.azure.LongRunningOperationOptions;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.network.PrepareNetworkPoliciesRequest;
import com.microsoft.azure.management.network.UnprepareNetworkPoliciesRequest;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.PageImpl;
import com.microsoft.azure.management.network.implementation.SubnetInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class SubnetsInner {
    private SubnetsService service;
    private NetworkManagementClientImpl client;

    public SubnetsInner(Retrofit retrofit, NetworkManagementClientImpl client) {
        this.service = (SubnetsService)retrofit.create(SubnetsService.class);
        this.client = client;
    }

    public void delete(String resourceGroupName, String virtualNetworkName, String subnetName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String virtualNetworkName, String subnetName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String virtualNetworkName, String subnetName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String virtualNetworkName, String subnetName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkName is required and cannot be null.");
        }
        if (subnetName == null) {
            throw new IllegalArgumentException("Parameter subnetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, virtualNetworkName, subnetName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String virtualNetworkName, String subnetName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String virtualNetworkName, String subnetName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String virtualNetworkName, String subnetName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String virtualNetworkName, String subnetName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkName is required and cannot be null.");
        }
        if (subnetName == null) {
            throw new IllegalArgumentException("Parameter subnetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.beginDelete(resourceGroupName, virtualNetworkName, subnetName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SubnetsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SubnetInner get(String resourceGroupName, String virtualNetworkName, String subnetName) {
        return (SubnetInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName).toBlocking().single()).body());
    }

    public ServiceFuture<SubnetInner> getAsync(String resourceGroupName, String virtualNetworkName, String subnetName, ServiceCallback<SubnetInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName), serviceCallback);
    }

    public Observable<SubnetInner> getAsync(String resourceGroupName, String virtualNetworkName, String subnetName) {
        return this.getWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName).map((Func1)new Func1<ServiceResponse<SubnetInner>, SubnetInner>(){

            public SubnetInner call(ServiceResponse<SubnetInner> response) {
                return (SubnetInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SubnetInner>> getWithServiceResponseAsync(String resourceGroupName, String virtualNetworkName, String subnetName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkName is required and cannot be null.");
        }
        if (subnetName == null) {
            throw new IllegalArgumentException("Parameter subnetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        String expand = null;
        return this.service.get(resourceGroupName, virtualNetworkName, subnetName, this.client.subscriptionId(), "2019-11-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SubnetInner>>>(){

            public Observable<ServiceResponse<SubnetInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SubnetsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public SubnetInner get(String resourceGroupName, String virtualNetworkName, String subnetName, String expand) {
        return (SubnetInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName, expand).toBlocking().single()).body());
    }

    public ServiceFuture<SubnetInner> getAsync(String resourceGroupName, String virtualNetworkName, String subnetName, String expand, ServiceCallback<SubnetInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName, expand), serviceCallback);
    }

    public Observable<SubnetInner> getAsync(String resourceGroupName, String virtualNetworkName, String subnetName, String expand) {
        return this.getWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName, expand).map((Func1)new Func1<ServiceResponse<SubnetInner>, SubnetInner>(){

            public SubnetInner call(ServiceResponse<SubnetInner> response) {
                return (SubnetInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SubnetInner>> getWithServiceResponseAsync(String resourceGroupName, String virtualNetworkName, String subnetName, String expand) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkName is required and cannot be null.");
        }
        if (subnetName == null) {
            throw new IllegalArgumentException("Parameter subnetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.get(resourceGroupName, virtualNetworkName, subnetName, this.client.subscriptionId(), "2019-11-01", expand, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SubnetInner>>>(){

            public Observable<ServiceResponse<SubnetInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SubnetsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SubnetInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SubnetInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public SubnetInner createOrUpdate(String resourceGroupName, String virtualNetworkName, String subnetName, SubnetInner subnetParameters) {
        return (SubnetInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName, subnetParameters).toBlocking().last()).body());
    }

    public ServiceFuture<SubnetInner> createOrUpdateAsync(String resourceGroupName, String virtualNetworkName, String subnetName, SubnetInner subnetParameters, ServiceCallback<SubnetInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName, subnetParameters), serviceCallback);
    }

    public Observable<SubnetInner> createOrUpdateAsync(String resourceGroupName, String virtualNetworkName, String subnetName, SubnetInner subnetParameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName, subnetParameters).map((Func1)new Func1<ServiceResponse<SubnetInner>, SubnetInner>(){

            public SubnetInner call(ServiceResponse<SubnetInner> response) {
                return (SubnetInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SubnetInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualNetworkName, String subnetName, SubnetInner subnetParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkName is required and cannot be null.");
        }
        if (subnetName == null) {
            throw new IllegalArgumentException("Parameter subnetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (subnetParameters == null) {
            throw new IllegalArgumentException("Parameter subnetParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)subnetParameters));
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.createOrUpdate(resourceGroupName, virtualNetworkName, subnetName, this.client.subscriptionId(), subnetParameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<SubnetInner>(){}.getType());
    }

    public SubnetInner beginCreateOrUpdate(String resourceGroupName, String virtualNetworkName, String subnetName, SubnetInner subnetParameters) {
        return (SubnetInner)((Object)((ServiceResponse)this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName, subnetParameters).toBlocking().single()).body());
    }

    public ServiceFuture<SubnetInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualNetworkName, String subnetName, SubnetInner subnetParameters, ServiceCallback<SubnetInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName, subnetParameters), serviceCallback);
    }

    public Observable<SubnetInner> beginCreateOrUpdateAsync(String resourceGroupName, String virtualNetworkName, String subnetName, SubnetInner subnetParameters) {
        return this.beginCreateOrUpdateWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName, subnetParameters).map((Func1)new Func1<ServiceResponse<SubnetInner>, SubnetInner>(){

            public SubnetInner call(ServiceResponse<SubnetInner> response) {
                return (SubnetInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<SubnetInner>> beginCreateOrUpdateWithServiceResponseAsync(String resourceGroupName, String virtualNetworkName, String subnetName, SubnetInner subnetParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkName is required and cannot be null.");
        }
        if (subnetName == null) {
            throw new IllegalArgumentException("Parameter subnetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (subnetParameters == null) {
            throw new IllegalArgumentException("Parameter subnetParameters is required and cannot be null.");
        }
        Validator.validate((Object)((Object)subnetParameters));
        String apiVersion = "2019-11-01";
        return this.service.beginCreateOrUpdate(resourceGroupName, virtualNetworkName, subnetName, this.client.subscriptionId(), subnetParameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<SubnetInner>>>(){

            public Observable<ServiceResponse<SubnetInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SubnetsInner.this.beginCreateOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<SubnetInner> beginCreateOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<SubnetInner>(){}.getType()).register(201, new TypeToken<SubnetInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void prepareNetworkPolicies(String resourceGroupName, String virtualNetworkName, String subnetName, PrepareNetworkPoliciesRequest prepareNetworkPoliciesRequestParameters) {
        ((ServiceResponse)this.prepareNetworkPoliciesWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName, prepareNetworkPoliciesRequestParameters).toBlocking().last()).body();
    }

    public ServiceFuture<Void> prepareNetworkPoliciesAsync(String resourceGroupName, String virtualNetworkName, String subnetName, PrepareNetworkPoliciesRequest prepareNetworkPoliciesRequestParameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.prepareNetworkPoliciesWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName, prepareNetworkPoliciesRequestParameters), serviceCallback);
    }

    public Observable<Void> prepareNetworkPoliciesAsync(String resourceGroupName, String virtualNetworkName, String subnetName, PrepareNetworkPoliciesRequest prepareNetworkPoliciesRequestParameters) {
        return this.prepareNetworkPoliciesWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName, prepareNetworkPoliciesRequestParameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> prepareNetworkPoliciesWithServiceResponseAsync(String resourceGroupName, String virtualNetworkName, String subnetName, PrepareNetworkPoliciesRequest prepareNetworkPoliciesRequestParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkName is required and cannot be null.");
        }
        if (subnetName == null) {
            throw new IllegalArgumentException("Parameter subnetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (prepareNetworkPoliciesRequestParameters == null) {
            throw new IllegalArgumentException("Parameter prepareNetworkPoliciesRequestParameters is required and cannot be null.");
        }
        Validator.validate((Object)prepareNetworkPoliciesRequestParameters);
        String apiVersion = "2019-11-01";
        Observable<Response<ResponseBody>> observable = this.service.prepareNetworkPolicies(resourceGroupName, virtualNetworkName, subnetName, this.client.subscriptionId(), prepareNetworkPoliciesRequestParameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<Void>(){}.getType());
    }

    public void beginPrepareNetworkPolicies(String resourceGroupName, String virtualNetworkName, String subnetName, PrepareNetworkPoliciesRequest prepareNetworkPoliciesRequestParameters) {
        ((ServiceResponse)this.beginPrepareNetworkPoliciesWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName, prepareNetworkPoliciesRequestParameters).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginPrepareNetworkPoliciesAsync(String resourceGroupName, String virtualNetworkName, String subnetName, PrepareNetworkPoliciesRequest prepareNetworkPoliciesRequestParameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginPrepareNetworkPoliciesWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName, prepareNetworkPoliciesRequestParameters), serviceCallback);
    }

    public Observable<Void> beginPrepareNetworkPoliciesAsync(String resourceGroupName, String virtualNetworkName, String subnetName, PrepareNetworkPoliciesRequest prepareNetworkPoliciesRequestParameters) {
        return this.beginPrepareNetworkPoliciesWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName, prepareNetworkPoliciesRequestParameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginPrepareNetworkPoliciesWithServiceResponseAsync(String resourceGroupName, String virtualNetworkName, String subnetName, PrepareNetworkPoliciesRequest prepareNetworkPoliciesRequestParameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkName is required and cannot be null.");
        }
        if (subnetName == null) {
            throw new IllegalArgumentException("Parameter subnetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (prepareNetworkPoliciesRequestParameters == null) {
            throw new IllegalArgumentException("Parameter prepareNetworkPoliciesRequestParameters is required and cannot be null.");
        }
        Validator.validate((Object)prepareNetworkPoliciesRequestParameters);
        String apiVersion = "2019-11-01";
        return this.service.beginPrepareNetworkPolicies(resourceGroupName, virtualNetworkName, subnetName, this.client.subscriptionId(), prepareNetworkPoliciesRequestParameters, "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SubnetsInner.this.beginPrepareNetworkPoliciesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginPrepareNetworkPoliciesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void unprepareNetworkPolicies(String resourceGroupName, String virtualNetworkName, String subnetName) {
        ((ServiceResponse)this.unprepareNetworkPoliciesWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> unprepareNetworkPoliciesAsync(String resourceGroupName, String virtualNetworkName, String subnetName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.unprepareNetworkPoliciesWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName), serviceCallback);
    }

    public Observable<Void> unprepareNetworkPoliciesAsync(String resourceGroupName, String virtualNetworkName, String subnetName) {
        return this.unprepareNetworkPoliciesWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> unprepareNetworkPoliciesWithServiceResponseAsync(String resourceGroupName, String virtualNetworkName, String subnetName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkName is required and cannot be null.");
        }
        if (subnetName == null) {
            throw new IllegalArgumentException("Parameter subnetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Object serviceName = null;
        UnprepareNetworkPoliciesRequest unprepareNetworkPoliciesRequestParameters = new UnprepareNetworkPoliciesRequest();
        unprepareNetworkPoliciesRequestParameters.withServiceName(null);
        Observable<Response<ResponseBody>> observable = this.service.unprepareNetworkPolicies(resourceGroupName, virtualNetworkName, subnetName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), unprepareNetworkPoliciesRequestParameters, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<Void>(){}.getType());
    }

    public void unprepareNetworkPolicies(String resourceGroupName, String virtualNetworkName, String subnetName, String serviceName) {
        ((ServiceResponse)this.unprepareNetworkPoliciesWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName, serviceName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> unprepareNetworkPoliciesAsync(String resourceGroupName, String virtualNetworkName, String subnetName, String serviceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.unprepareNetworkPoliciesWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName, serviceName), serviceCallback);
    }

    public Observable<Void> unprepareNetworkPoliciesAsync(String resourceGroupName, String virtualNetworkName, String subnetName, String serviceName) {
        return this.unprepareNetworkPoliciesWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName, serviceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> unprepareNetworkPoliciesWithServiceResponseAsync(String resourceGroupName, String virtualNetworkName, String subnetName, String serviceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkName is required and cannot be null.");
        }
        if (subnetName == null) {
            throw new IllegalArgumentException("Parameter subnetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        UnprepareNetworkPoliciesRequest unprepareNetworkPoliciesRequestParameters = new UnprepareNetworkPoliciesRequest();
        unprepareNetworkPoliciesRequestParameters.withServiceName(serviceName);
        Observable<Response<ResponseBody>> observable = this.service.unprepareNetworkPolicies(resourceGroupName, virtualNetworkName, subnetName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), unprepareNetworkPoliciesRequestParameters, this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<Void>(){}.getType());
    }

    public void beginUnprepareNetworkPolicies(String resourceGroupName, String virtualNetworkName, String subnetName) {
        ((ServiceResponse)this.beginUnprepareNetworkPoliciesWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginUnprepareNetworkPoliciesAsync(String resourceGroupName, String virtualNetworkName, String subnetName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUnprepareNetworkPoliciesWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName), serviceCallback);
    }

    public Observable<Void> beginUnprepareNetworkPoliciesAsync(String resourceGroupName, String virtualNetworkName, String subnetName) {
        return this.beginUnprepareNetworkPoliciesWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginUnprepareNetworkPoliciesWithServiceResponseAsync(String resourceGroupName, String virtualNetworkName, String subnetName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkName is required and cannot be null.");
        }
        if (subnetName == null) {
            throw new IllegalArgumentException("Parameter subnetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        Object serviceName = null;
        UnprepareNetworkPoliciesRequest unprepareNetworkPoliciesRequestParameters = new UnprepareNetworkPoliciesRequest();
        unprepareNetworkPoliciesRequestParameters.withServiceName(null);
        return this.service.beginUnprepareNetworkPolicies(resourceGroupName, virtualNetworkName, subnetName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), unprepareNetworkPoliciesRequestParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SubnetsInner.this.beginUnprepareNetworkPoliciesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public void beginUnprepareNetworkPolicies(String resourceGroupName, String virtualNetworkName, String subnetName, String serviceName) {
        ((ServiceResponse)this.beginUnprepareNetworkPoliciesWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName, serviceName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginUnprepareNetworkPoliciesAsync(String resourceGroupName, String virtualNetworkName, String subnetName, String serviceName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginUnprepareNetworkPoliciesWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName, serviceName), serviceCallback);
    }

    public Observable<Void> beginUnprepareNetworkPoliciesAsync(String resourceGroupName, String virtualNetworkName, String subnetName, String serviceName) {
        return this.beginUnprepareNetworkPoliciesWithServiceResponseAsync(resourceGroupName, virtualNetworkName, subnetName, serviceName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginUnprepareNetworkPoliciesWithServiceResponseAsync(String resourceGroupName, String virtualNetworkName, String subnetName, String serviceName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkName is required and cannot be null.");
        }
        if (subnetName == null) {
            throw new IllegalArgumentException("Parameter subnetName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        UnprepareNetworkPoliciesRequest unprepareNetworkPoliciesRequestParameters = new UnprepareNetworkPoliciesRequest();
        unprepareNetworkPoliciesRequestParameters.withServiceName(serviceName);
        return this.service.beginUnprepareNetworkPolicies(resourceGroupName, virtualNetworkName, subnetName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), unprepareNetworkPoliciesRequestParameters, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = SubnetsInner.this.beginUnprepareNetworkPoliciesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginUnprepareNetworkPoliciesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SubnetInner> list(String resourceGroupName, String virtualNetworkName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, virtualNetworkName).toBlocking().single();
        return new PagedList<SubnetInner>((Page)response.body()){

            public Page<SubnetInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SubnetsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SubnetInner>> listAsync(String resourceGroupName, String virtualNetworkName, ListOperationCallback<SubnetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, virtualNetworkName), (Func1)new Func1<String, Observable<ServiceResponse<Page<SubnetInner>>>>(){

            public Observable<ServiceResponse<Page<SubnetInner>>> call(String nextPageLink) {
                return SubnetsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SubnetInner>> listAsync(String resourceGroupName, String virtualNetworkName) {
        return this.listWithServiceResponseAsync(resourceGroupName, virtualNetworkName).map((Func1)new Func1<ServiceResponse<Page<SubnetInner>>, Page<SubnetInner>>(){

            public Page<SubnetInner> call(ServiceResponse<Page<SubnetInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SubnetInner>>> listWithServiceResponseAsync(String resourceGroupName, String virtualNetworkName) {
        return this.listSinglePageAsync(resourceGroupName, virtualNetworkName).concatMap((Func1)new Func1<ServiceResponse<Page<SubnetInner>>, Observable<ServiceResponse<Page<SubnetInner>>>>(){

            public Observable<ServiceResponse<Page<SubnetInner>>> call(ServiceResponse<Page<SubnetInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SubnetsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SubnetInner>>> listSinglePageAsync(String resourceGroupName, String virtualNetworkName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (virtualNetworkName == null) {
            throw new IllegalArgumentException("Parameter virtualNetworkName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2019-11-01";
        return this.service.list(resourceGroupName, virtualNetworkName, this.client.subscriptionId(), "2019-11-01", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SubnetInner>>>>(){

            public Observable<ServiceResponse<Page<SubnetInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SubnetsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SubnetInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SubnetInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<SubnetInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<SubnetInner>((Page)response.body()){

            public Page<SubnetInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)SubnetsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<SubnetInner>> listNextAsync(String nextPageLink, ServiceFuture<List<SubnetInner>> serviceFuture, ListOperationCallback<SubnetInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<SubnetInner>>>>(){

            public Observable<ServiceResponse<Page<SubnetInner>>> call(String nextPageLink) {
                return SubnetsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<SubnetInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<SubnetInner>>, Page<SubnetInner>>(){

            public Page<SubnetInner> call(ServiceResponse<Page<SubnetInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<SubnetInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<SubnetInner>>, Observable<ServiceResponse<Page<SubnetInner>>>>(){

            public Observable<ServiceResponse<Page<SubnetInner>>> call(ServiceResponse<Page<SubnetInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(SubnetsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<SubnetInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<SubnetInner>>>>(){

            public Observable<ServiceResponse<Page<SubnetInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = SubnetsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<SubnetInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<SubnetInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface SubnetsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.Subnets delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkName") String var2, @Path(value="subnetName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.Subnets beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkName") String var2, @Path(value="subnetName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.Subnets get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkName") String var2, @Path(value="subnetName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Query(value="$expand") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.Subnets createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkName") String var2, @Path(value="subnetName") String var3, @Path(value="subscriptionId") String var4, @Body SubnetInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.Subnets beginCreateOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}")
        public Observable<Response<ResponseBody>> beginCreateOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkName") String var2, @Path(value="subnetName") String var3, @Path(value="subscriptionId") String var4, @Body SubnetInner var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.Subnets prepareNetworkPolicies"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}/PrepareNetworkPolicies")
        public Observable<Response<ResponseBody>> prepareNetworkPolicies(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkName") String var2, @Path(value="subnetName") String var3, @Path(value="subscriptionId") String var4, @Body PrepareNetworkPoliciesRequest var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.Subnets beginPrepareNetworkPolicies"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}/PrepareNetworkPolicies")
        public Observable<Response<ResponseBody>> beginPrepareNetworkPolicies(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkName") String var2, @Path(value="subnetName") String var3, @Path(value="subscriptionId") String var4, @Body PrepareNetworkPoliciesRequest var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.Subnets unprepareNetworkPolicies"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}/UnprepareNetworkPolicies")
        public Observable<Response<ResponseBody>> unprepareNetworkPolicies(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkName") String var2, @Path(value="subnetName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body UnprepareNetworkPoliciesRequest var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.Subnets beginUnprepareNetworkPolicies"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets/{subnetName}/UnprepareNetworkPolicies")
        public Observable<Response<ResponseBody>> beginUnprepareNetworkPolicies(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkName") String var2, @Path(value="subnetName") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Body UnprepareNetworkPoliciesRequest var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.Subnets list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{virtualNetworkName}/subnets")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="virtualNetworkName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.network.Subnets listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

