/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mesh.gprc;

import io.grpc.Context;
import io.grpc.Deadline;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class GrpcSupport {
    @Nonnull
    public static Instant getDeadline(@Nonnull Duration timeout) {
        Objects.requireNonNull(timeout, "timeout");
        Instant result = Instant.now().plus(timeout.toMillis() > 0L ? timeout : Duration.ofDays(365L));
        Deadline deadline = Context.current().getDeadline();
        if (deadline == null) {
            return result;
        }
        Instant grpcDeadline = Instant.now().plusMillis(deadline.timeRemaining(TimeUnit.MILLISECONDS));
        return grpcDeadline.isBefore(result) ? grpcDeadline : result;
    }

    @Nonnull
    public static Duration getTimeout() {
        Deadline deadline = Context.current().getDeadline();
        if (deadline == null) {
            return Duration.ZERO;
        }
        return Duration.ofMillis(Math.max(1L, deadline.timeRemaining(TimeUnit.MILLISECONDS)));
    }

    @Nonnull
    public static Duration maybeReduceToDeadline(@Nonnull Duration timeout) {
        Deadline deadline = Context.current().getDeadline();
        if (deadline == null) {
            return timeout;
        }
        Duration grpcTimeout = Duration.ofMillis(Math.max(1L, deadline.timeRemaining(TimeUnit.MILLISECONDS)));
        return grpcTimeout.compareTo(timeout) < 0 ? grpcTimeout : timeout;
    }
}

