/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mesh.migration;

import com.atlassian.bitbucket.mesh.io.MoreFiles;
import com.atlassian.bitbucket.mesh.io.UnderLock;
import com.atlassian.bitbucket.mesh.migration.HierarchyMigrationState;
import com.atlassian.bitbucket.mesh.transaction.FileTransactionLog;
import com.atlassian.bitbucket.mesh.transaction.TransactionLog;
import jakarta.annotation.Nonnull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHierarchyMigrationState
implements HierarchyMigrationState {
    private static final String PATH_COMPLETED_MARKER = "completed.log";
    private static final String PATH_MIGRATION_DETAILS = "details.dat";
    private static final String PATH_RUNNING_MARKER = "running.log";
    private static final String PATH_TMP = "tmp";
    private static final String PATH_TRANSACTION_LOG = "transactions.dat";
    private static final Logger log = LoggerFactory.getLogger(DefaultHierarchyMigrationState.class);
    private final String hierarchyId;
    private final Path migrationDir;
    private final Path tmpDir;
    private final int targetPartition;
    private TransactionLog transactionLog;

    public DefaultHierarchyMigrationState(String hierarchyId, Path migrationDir) throws IOException {
        this.hierarchyId = hierarchyId;
        this.migrationDir = migrationDir;
        this.targetPartition = DefaultHierarchyMigrationState.getTargetPartition(this.getDetailsPath());
        this.tmpDir = migrationDir.resolve(PATH_TMP);
    }

    public DefaultHierarchyMigrationState(String hierarchyId, Path migrationDir, int targetPartition) throws IOException {
        this.hierarchyId = hierarchyId;
        this.migrationDir = migrationDir;
        this.targetPartition = targetPartition;
        MoreFiles.mkdir((Path)migrationDir);
        MoreFiles.write((Path)this.getDetailsPath(), (String)Integer.toString(targetPartition), (Charset)StandardCharsets.UTF_8, (OpenOption[])new OpenOption[0]);
        this.tmpDir = MoreFiles.mkdir((Path)migrationDir, (String)PATH_TMP);
    }

    @Override
    public void clear(boolean everything) {
        if (everything) {
            this.deleteSafely(this.migrationDir, "migration dir");
        } else {
            this.getTransactionLog().process(transactions -> TransactionLog.Result.proceed(), 500);
            this.deleteSafely(this.tmpDir, "tmp directory");
        }
    }

    @Override
    public int getTargetPartition() {
        return this.targetPartition;
    }

    @Override
    @Nonnull
    public Path getTmpDir() {
        return this.tmpDir;
    }

    @Override
    @Nonnull
    public TransactionLog getTransactionLog() {
        if (this.transactionLog == null) {
            this.transactionLog = new FileTransactionLog(this.getTransactionLogPath());
        }
        return this.transactionLog;
    }

    @Override
    public boolean isCompleted() {
        return MoreFiles.canOpen((Path)this.getCompletedMarker());
    }

    @Override
    public boolean isRunning() {
        return MoreFiles.canOpen((Path)this.getRunningMarker());
    }

    @Override
    public void start() throws IOException {
        UnderLock.forFile((Path)this.getRunningMarker()).edit((reader, writer) -> {
            String currentContent;
            Instant now = Instant.now();
            if (reader != null && StringUtils.isNotBlank((CharSequence)(currentContent = reader.readLine()))) {
                log.warn("Overwriting migration running marker for {} (content = {})", (Object)this.hierarchyId, (Object)currentContent);
            }
            writer.write(Long.toString(now.toEpochMilli()));
            writer.write(";");
            writer.write(DateTimeFormatter.ISO_INSTANT.format(now));
            writer.write(";");
            writer.write("Started migration to partition ");
            writer.write(Integer.toString(this.targetPartition));
            writer.write(";");
            writer.write(DefaultHierarchyMigrationState.getProcessName());
        }, true);
    }

    @Override
    public void stop(boolean completed) {
        if (completed) {
            String isoInstant = DateTimeFormatter.ISO_INSTANT.format(Instant.now());
            try {
                MoreFiles.write((Path)this.getCompletedMarker(), (String)("Migration to partition " + this.targetPartition + " completed on " + isoInstant), (Charset)StandardCharsets.UTF_8, (OpenOption[])new OpenOption[0]);
            }
            catch (IOException e) {
                log.error("[{}] Failed to mark hierarchy as migrated", (Object)this.hierarchyId, (Object)e);
            }
        } else {
            this.deleteSafely(this.getCompletedMarker(), "completed marker");
        }
        this.deleteSafely(this.getRunningMarker(), "running marker");
    }

    private static String getProcessName() {
        return ManagementFactory.getRuntimeMXBean().getName();
    }

    private static int getTargetPartition(Path detailsPath) throws IOException {
        return Integer.parseInt(MoreFiles.toString((Path)detailsPath, (Charset)StandardCharsets.UTF_8));
    }

    private void deleteSafely(Path path, String name) {
        try {
            MoreFiles.deleteRecursively((Path)path);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            log.debug("Could not delete {} for migration of {}; the file was not found", (Object)name, (Object)this.hierarchyId);
        }
        catch (IOException e) {
            log.error("Could not delete {} for migration of {}", new Object[]{name, this.hierarchyId, e});
        }
    }

    private Path getDetailsPath() {
        return this.migrationDir.resolve(PATH_MIGRATION_DETAILS);
    }

    private Path getCompletedMarker() {
        return this.migrationDir.resolve(PATH_COMPLETED_MARKER);
    }

    private Path getRunningMarker() {
        return this.migrationDir.resolve(PATH_RUNNING_MARKER);
    }

    private Path getTransactionLogPath() {
        return this.migrationDir.resolve(PATH_TRANSACTION_LOG);
    }
}

