/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mesh.migration;

import com.atlassian.bitbucket.mesh.migration.DefaultHierarchyMigrationState;
import com.atlassian.bitbucket.mesh.migration.HierarchyMigrationState;
import com.atlassian.bitbucket.mesh.migration.MigrationStateManager;
import jakarta.annotation.Nonnull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMigrationStateManager
implements MigrationStateManager {
    private static final Path PATH_MIGRATION = Paths.get("migration", new String[0]);
    private static final Logger log = LoggerFactory.getLogger(DefaultMigrationStateManager.class);
    private final Path hierarchiesDataDir;

    public DefaultMigrationStateManager(Path hierarchiesDataDir) {
        this.hierarchiesDataDir = hierarchiesDataDir;
    }

    @Override
    @Nonnull
    public HierarchyMigrationState createForHierarchy(@Nonnull String hierarchyId, int partition) throws IOException {
        return new DefaultHierarchyMigrationState(hierarchyId, this.getMigrationDir(hierarchyId), partition);
    }

    @Override
    @Nonnull
    public Optional<HierarchyMigrationState> getForHierarchy(@Nonnull String hierarchyId) {
        Path migrationDir = this.getMigrationDir(Objects.requireNonNull(hierarchyId, "hierarchyId"));
        try {
            return Optional.of(new DefaultHierarchyMigrationState(hierarchyId, migrationDir));
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
        }
        catch (IOException e) {
            log.warn("Cannot open migration details file for hierarchy {}", (Object)hierarchyId, (Object)e);
        }
        catch (NumberFormatException e) {
            log.warn("Migration details file for hierarchy {} is invalid", (Object)hierarchyId);
        }
        return Optional.empty();
    }

    private Path getMigrationDir(String hierarchyId) {
        Objects.requireNonNull(hierarchyId, "hierarchyId");
        return this.hierarchiesDataDir.resolve(hierarchyId.substring(0, 2)).resolve(hierarchyId.substring(2)).resolve(PATH_MIGRATION);
    }
}

