/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mesh.transaction;

import com.atlassian.bitbucket.mesh.rpc.v1.RpcTransaction;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public interface TransactionLog {
    public void append(@Nonnull RpcTransaction var1);

    public void process(@Nonnull Processor var1, int var2);

    public static class Result {
        private static final Result ABORT = new Result(true, 0, null);
        private static final Result PROCEED = new Result(false, 0, null);
        private final boolean abort;
        private final Exception exception;
        private final int unprocessed;

        Result(boolean abort, int unprocessed, Exception exception) {
            this.abort = abort;
            this.exception = exception;
            this.unprocessed = unprocessed;
        }

        @Nonnull
        public static Result abort() {
            return ABORT;
        }

        @Nonnull
        public static Result abortAndReturn(int unprocessed) {
            return new Result(true, unprocessed, null);
        }

        @Nonnull
        public static Result error(int unprocessed, @Nonnull Exception exception) {
            return new Result(true, unprocessed, Objects.requireNonNull(exception, "exception"));
        }

        @Nonnull
        public static Result proceed() {
            return PROCEED;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            return this.abort == result.abort && this.unprocessed == result.unprocessed && Objects.equals(this.exception, result.exception);
        }

        @Nonnull
        public Optional<Exception> getException() {
            return Optional.ofNullable(this.exception);
        }

        public int getUnprocessed() {
            return this.unprocessed;
        }

        public int hashCode() {
            return Objects.hash(this.abort, this.unprocessed, this.exception);
        }

        public boolean isAbort() {
            return this.abort;
        }

        public boolean isError() {
            return this.exception != null;
        }
    }

    @FunctionalInterface
    public static interface Processor {
        @Nonnull
        public Result process(@Nonnull List<RpcTransaction> var1);
    }
}

