/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.audit;

import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.bitbucket.audit.AuditEventConverter;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.stash.internal.notification.repository.event.RepositoryNotificationSettingsUpdatedEvent;
import com.atlassian.stash.internal.notification.repository.model.RepositoryNotificationSettings;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.Optional;

public class RepositoryNotificationsUpdatedEventConverter
implements AuditEventConverter<RepositoryNotificationSettingsUpdatedEvent> {
    @VisibleForTesting
    static final String KEY_PULL_REQUEST_SCOPE = "bitbucket.notification.audit.changedvalue.repositorynotificationsettingsupdated.pullrequestscope";
    @VisibleForTesting
    static final String KEY_PUSH_SCOPE = "bitbucket.notification.audit.changedvalue.repositorynotificationsettingsupdated.pushscope";

    @Nonnull
    public AuditEvent convert(@Nonnull RepositoryNotificationSettingsUpdatedEvent event, @Nonnull AuditEvent.Builder builder) {
        Repository repository = event.getRepository();
        Optional<RepositoryNotificationSettings> previousSettings = event.getPreviousSettings();
        ChangedValue pullRequestScopeChange = ChangedValue.fromI18nKeys((String)KEY_PULL_REQUEST_SCOPE).from((String)previousSettings.map(ps1 -> ps1.getPullRequestNotificationScope().toString()).orElse(null)).to(event.getPullRequestNotificationScope().toString()).build();
        ChangedValue pushScopeChange = ChangedValue.fromI18nKeys((String)KEY_PUSH_SCOPE).from((String)previousSettings.map(ps -> ps.getPushNotificationScope().toString()).orElse(null)).to(event.getPushNotificationScope().toString()).build();
        return builder.affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)repository)).addChangedValueIfDifferent(pullRequestScopeChange).addChangedValueIfDifferent(pushScopeChange).build();
    }
}

