/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.batch;

import com.atlassian.stash.internal.notification.batch.dao.UserNotification;
import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.Set;

public abstract class BatchNotificationAccumulator {
    protected String batchId;
    protected Integer userId;
    private final Callback callback;
    private Set<UserNotification> notifications;
    private Set<Long> idsToDiscard;

    protected BatchNotificationAccumulator(Callback callback) {
        this.callback = callback;
    }

    public void add(UserNotification notification) {
        if (this.isNewBatch(notification)) {
            this.dispatch(this.notifications, this.userId, this.batchId, this.idsToDiscard);
            this.initializeForNewBatch(notification);
        }
        this.addOrDiscard(notification);
    }

    public void onEnd() {
        this.dispatch(this.notifications, this.userId, this.batchId, this.idsToDiscard);
    }

    protected abstract String calculateBatchId(UserNotification var1);

    protected abstract boolean includeInBatch(UserNotification var1);

    protected void initializeForNewBatch(UserNotification notification) {
        this.idsToDiscard = new HashSet<Long>();
        this.notifications = new HashSet<UserNotification>();
        this.userId = notification.getUserId();
        this.batchId = this.calculateBatchId(notification);
    }

    private void dispatch(Set<UserNotification> notifications, Integer userId, String batchId, Set<Long> idsToDiscard) {
        if (notifications == null || notifications.isEmpty()) {
            return;
        }
        this.callback.onDispatch(batchId, userId, notifications, idsToDiscard);
    }

    private boolean isDifferentBatch(UserNotification notification) {
        return !this.calculateBatchId(notification).equals(this.batchId);
    }

    private boolean isNewBatch(UserNotification notification) {
        if (this.batchId == null && this.userId == null) {
            return true;
        }
        return this.isDifferentBatch(notification) || this.userId.intValue() != notification.getUserId();
    }

    private void addOrDiscard(UserNotification notification) {
        if (this.includeInBatch(notification)) {
            this.notifications.add(notification);
        } else {
            this.idsToDiscard.add(notification.getId());
        }
    }

    @FunctionalInterface
    public static interface Callback {
        public void onDispatch(@Nonnull String var1, int var2, @Nonnull Set<UserNotification> var3, @Nonnull Set<Long> var4);
    }
}

