/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.batch;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.stash.internal.notification.NotificationConfig;
import com.atlassian.stash.internal.notification.batch.BatchNotificationJob;
import com.atlassian.stash.internal.notification.batch.BatchSender;
import com.atlassian.stash.internal.notification.batch.BatchTiming;
import com.atlassian.stash.internal.notification.batch.dao.UserNotification;
import com.atlassian.stash.internal.notification.batch.dao.UserNotificationDao;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchNotificationDispatcher {
    private static final Logger log = LoggerFactory.getLogger(BatchNotificationJob.class);
    private final BatchTiming batchTiming;
    private final NotificationConfig config;
    private final UserNotificationDao userNotificationDao;
    private final UserService userService;
    private final TransactionTemplate transactionTemplate;

    public BatchNotificationDispatcher(BatchTiming batchTiming, NotificationConfig config, UserNotificationDao userNotificationDao, UserService userService, TransactionTemplate transactionTemplate) {
        this.batchTiming = batchTiming;
        this.config = config;
        this.userNotificationDao = userNotificationDao;
        this.userService = userService;
        this.transactionTemplate = transactionTemplate;
    }

    public void dispatch(@Nonnull String batchId, @Nonnull Set<UserNotification> notifications, long now, @Nonnull BatchSender sender, int userId, @Nonnull Set<Long> idsToDiscard) {
        if (!idsToDiscard.isEmpty()) {
            this.deleteById(idsToDiscard);
        }
        if ((long)notifications.size() >= this.config.getBatchFlushLimit() || this.batchTiming.batchShouldBeSent(notifications, now)) {
            this.sendBatch(batchId, notifications, sender, userId);
        } else if (this.batchTiming.batchCanBeDiscarded(notifications, now)) {
            this.cleanupNotifications(notifications);
        }
    }

    private void cleanupNotifications(Collection<UserNotification> notifications) {
        Set processed = (Set)notifications.stream().map(UserNotification::getId).collect(MoreCollectors.toImmutableSet());
        if (!processed.isEmpty()) {
            this.deleteById(processed);
        }
    }

    private void deleteById(Set<Long> processed) {
        this.transactionTemplate.execute(() -> {
            this.userNotificationDao.delete(processed);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBatch(String batchId, Set<UserNotification> notifications, BatchSender sender, int userId) {
        boolean cleanUpNotifications = false;
        try {
            ApplicationUser user = this.userService.getUserById(userId);
            cleanUpNotifications = user == null || sender.send(batchId, user, notifications);
        }
        catch (Exception ex) {
            cleanUpNotifications = true;
            log.error("Failed to deliver notifications", (Throwable)ex);
        }
        finally {
            if (cleanUpNotifications) {
                this.cleanupNotifications(notifications);
            }
        }
    }
}

