/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.batch;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.stash.internal.notification.batch.BatchNotificationAccumulator;
import com.atlassian.stash.internal.notification.batch.BatchNotificationDispatcher;
import com.atlassian.stash.internal.notification.batch.BatchSender;
import com.atlassian.stash.internal.notification.batch.dao.UserNotificationDao;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchNotificationJob
implements LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(BatchNotificationJob.class);
    private static final String SENDER_SUFFIX = ".batch.sending.lock";
    private final BatchNotificationDispatcher dispatcher;
    private final LockService lockService;
    private final SchedulerService schedulerService;
    private final Collection<BatchSender> senders;
    private final UserNotificationDao userNotificationDao;

    public BatchNotificationJob(BatchNotificationDispatcher dispatcher, LockService lockService, SchedulerService schedulerService, List<BatchSender> senders, UserNotificationDao userNotificationDao) {
        this.dispatcher = dispatcher;
        this.lockService = lockService;
        this.schedulerService = schedulerService;
        this.userNotificationDao = userNotificationDao;
        this.senders = senders.stream().collect(Collectors.toMap(BatchSender::getId, Function.identity(), (s1, s2) -> {
            log.warn("Batch senders with duplicate IDs '{}' detected, ignoring the second one: {}, {}", new Object[]{s1.getId(), s1, s2});
            return s1;
        })).values();
    }

    public void onStart() {
        this.senders.forEach(sender -> {
            JobRunnerKey jobRunnerKey = BatchNotificationJob.getJobRunnerKey(sender);
            this.schedulerService.registerJobRunner(jobRunnerKey, request -> {
                try (LockGuard guard = LockGuard.tryLock((Lock)this.lockService.getLock(BatchNotificationJob.getLockName(sender)));){
                    if (guard != null) {
                        this.process((BatchSender)sender);
                    }
                }
                return JobRunnerResponse.success();
            });
            this.scheduleJob((BatchSender)sender, jobRunnerKey);
        });
    }

    public void onStop() {
        this.senders.stream().map(BatchNotificationJob::getJobRunnerKey).forEach(arg_0 -> ((SchedulerService)this.schedulerService).unregisterJobRunner(arg_0));
    }

    public int notificationCount() {
        return this.userNotificationDao.count();
    }

    public void processAllSenders() {
        this.processAllSenders(System.currentTimeMillis());
    }

    public void processAllSenders(long now) {
        this.senders.forEach(sender -> {
            try (LockGuard ignored = LockGuard.lock((Lock)this.lockService.getLock(BatchNotificationJob.getLockName(sender)));){
                this.process((BatchSender)sender, now);
            }
        });
    }

    private static JobRunnerKey getJobRunnerKey(BatchSender sender) {
        return JobRunnerKey.of((String)String.format("%s.%s", sender.getClass().getName(), sender.getId()));
    }

    private static String getLockName(BatchSender sender) {
        return sender.getId() + SENDER_SUFFIX;
    }

    private void process(BatchSender sender) {
        this.process(sender, System.currentTimeMillis());
    }

    private void process(BatchSender sender, long now) {
        try (Timer ignored = TimerUtils.start((String)"Batch notification job");){
            BatchNotificationAccumulator.Callback callback = (batchId, userId, notifications, idsToDiscard) -> this.dispatcher.dispatch(batchId, notifications, now, sender, userId, idsToDiscard);
            BatchNotificationAccumulator batchNotificationAccumulator = sender.createAccumulator(callback);
            this.userNotificationDao.streamBySenderId(sender.getId(), batchNotificationAccumulator::add);
            batchNotificationAccumulator.onEnd();
        }
    }

    private void scheduleJob(BatchSender sender, JobRunnerKey jobRunnerKey) {
        try {
            long interval = TimeUnit.MINUTES.toMillis(1L);
            JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)interval, (Date)new Date(System.currentTimeMillis() + interval)));
            this.schedulerService.scheduleJob(JobId.of((String)sender.getId()), jobConfig);
        }
        catch (SchedulerServiceException e) {
            log.error("Failed to schedule batch notification job with key {}", (Object)jobRunnerKey, (Object)e);
        }
    }
}

