/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.batch;

import com.atlassian.stash.internal.notification.NotificationConfig;
import com.atlassian.stash.internal.notification.batch.dao.UserNotification;
import io.atlassian.fugue.Pair;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class BatchTiming {
    private final NotificationConfig notificationConfig;

    public BatchTiming(NotificationConfig notificationConfig) {
        this.notificationConfig = notificationConfig;
    }

    public boolean batchShouldBeSent(@Nonnull Iterable<UserNotification> notifications, long currentTimeMillis) {
        Pair<Date, Date> timestamps = this.getMinMaxTimestamps(notifications);
        long firstMillis = ((Date)timestamps.left()).getTime();
        long lastMillis = ((Date)timestamps.right()).getTime();
        if (firstMillis < currentTimeMillis - this.getMaxWaitTimeMillis()) {
            return true;
        }
        return lastMillis < currentTimeMillis - this.getMinWaitTimeMillis();
    }

    public boolean batchCanBeDiscarded(@Nonnull Iterable<UserNotification> notifications, long currentTimeMillis) {
        long maxResendTime;
        long firstMillis = ((Date)this.getMinMaxTimestamps(notifications).left()).getTime();
        return firstMillis < currentTimeMillis - (maxResendTime = this.getMaxWaitTimeMillis() * 2L);
    }

    private Pair<Date, Date> getMinMaxTimestamps(Iterable<UserNotification> notifications) {
        Date min = null;
        Date max = null;
        for (UserNotification notification : notifications) {
            Date timestamp = notification.getTimestamp();
            if (min == null || timestamp.before(min)) {
                min = timestamp;
            }
            if (max != null && !timestamp.after(max)) continue;
            max = timestamp;
        }
        return Pair.pair(min, max);
    }

    private long getMaxWaitTimeMillis() {
        return TimeUnit.MINUTES.toMillis(this.notificationConfig.getBatchMaxWaitMinutes());
    }

    private long getMinWaitTimeMillis() {
        return TimeUnit.MINUTES.toMillis(this.notificationConfig.getBatchMinWaitMinutes());
    }
}

