/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.batch;

import com.atlassian.stash.internal.notification.batch.DataMapper;
import com.atlassian.stash.internal.notification.pull.activity.ActivityData;
import com.atlassian.stash.internal.notification.pull.activity.CommentData;
import com.atlassian.stash.internal.notification.pull.activity.CustomData;
import com.atlassian.stash.internal.notification.pull.activity.ToBranchUpdateData;
import com.atlassian.stash.internal.notification.repository.batch.RepositoryUpdateData;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Data {
    protected static final DataMapper DATA_MAPPER = new DataMapper();
    private static final Logger log = LoggerFactory.getLogger(Data.class);

    @Nonnull
    public static Optional<Data> decode(String input) {
        Map<String, ?> map;
        try {
            map = DATA_MAPPER.read(input);
        }
        catch (IOException e) {
            log.warn("Unable to parse notification data. Discarding: {}", (Object)input, (Object)e);
            return Optional.empty();
        }
        ActivityData activityData = ActivityData.tryDecode(map);
        if (activityData != null) {
            return Optional.of(activityData);
        }
        CommentData commentData = CommentData.tryDecode(map);
        if (commentData != null) {
            return Optional.of(commentData);
        }
        ToBranchUpdateData toBranchUpdateData = ToBranchUpdateData.tryDecode(map);
        if (toBranchUpdateData != null) {
            return Optional.of(toBranchUpdateData);
        }
        RepositoryUpdateData repositoryUpdateData = RepositoryUpdateData.tryDecode(map);
        if (repositoryUpdateData != null) {
            return Optional.of(repositoryUpdateData);
        }
        CustomData customData = CustomData.tryDecode(map);
        if (customData != null) {
            return Optional.of(customData);
        }
        return Optional.empty();
    }

    public abstract String encode() throws IOException;
}

