/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.batch;

import com.atlassian.stash.internal.notification.batch.BatchNotificationAccumulator;
import com.atlassian.stash.internal.notification.batch.Data;
import com.atlassian.stash.internal.notification.batch.dao.UserNotification;
import com.atlassian.stash.internal.notification.pull.activity.PullRequestBatchId;
import com.atlassian.stash.internal.notification.repository.batch.RepositoryUpdateData;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class RepositoryBatchNotificationAccumulator
extends BatchNotificationAccumulator {
    private int branchCount;
    private Map<Long, Integer> pullRequestIds = new HashMap<Long, Integer>();

    public RepositoryBatchNotificationAccumulator(BatchNotificationAccumulator.Callback callback) {
        super(callback);
    }

    @Override
    protected String calculateBatchId(UserNotification notification) {
        return this.getRepositoryId(notification);
    }

    @Override
    protected boolean includeInBatch(UserNotification notification) {
        Integer amountOfActivities;
        Long pullRequestId = this.getPullRequestId(notification);
        if (pullRequestId == null) {
            Optional<Data> data = Data.decode(notification.getData());
            if (data.isPresent() && data.get() instanceof RepositoryUpdateData && this.branchCount < 51) {
                RepositoryUpdateData repoData = (RepositoryUpdateData)data.get();
                this.branchCount += repoData.getDetailedRefChanges().size();
                return true;
            }
        } else if ((this.pullRequestIds.keySet().contains(pullRequestId) || this.pullRequestIds.size() < 51) && (amountOfActivities = this.pullRequestIds.computeIfAbsent(pullRequestId, id -> 0)) < 6) {
            this.pullRequestIds.compute(pullRequestId, (id, count) -> count + 1);
            return true;
        }
        return false;
    }

    @Override
    protected void initializeForNewBatch(UserNotification notification) {
        super.initializeForNewBatch(notification);
        this.branchCount = 0;
        this.pullRequestIds = new HashMap<Long, Integer>();
    }

    private Long getPullRequestId(UserNotification notification) {
        PullRequestBatchId batchId = PullRequestBatchId.decode(notification.getBatchId());
        return batchId != null ? Long.valueOf(batchId.getPullRequestId()) : null;
    }

    private String getRepositoryId(UserNotification notification) {
        PullRequestBatchId batchId = PullRequestBatchId.decode(notification.getBatchId());
        return batchId == null ? notification.getBatchId() : String.valueOf(batchId.getRepositoryId());
    }
}

