/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.batch.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.stash.internal.notification.batch.dao.AoUserNotification;
import com.atlassian.stash.internal.notification.batch.dao.UserNotification;
import com.atlassian.stash.internal.notification.batch.dao.UserNotificationDao;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.java.ao.Query;

public class AoUserNotificationDao
extends AbstractAoDao
implements UserNotificationDao {
    private static final int MAX_IN_PARAMS = 500;

    public AoUserNotificationDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    public int count() {
        return this.ao.count(AoUserNotification.class);
    }

    @Override
    @Nonnull
    public UserNotification create(int userId, @Nonnull Date date, @Nonnull String batchSenderId, @Nonnull String batchId, @Nonnull String data) {
        return (UserNotification)this.ao.create(AoUserNotification.class, (Map)ImmutableMap.builder().put((Object)"USER_ID", (Object)userId).put((Object)"DATE", (Object)Objects.requireNonNull(date, "date")).put((Object)"BATCH_SENDER_ID", (Object)Objects.requireNonNull(batchSenderId, "batchSenderId")).put((Object)"BATCH_ID", (Object)Objects.requireNonNull(batchId, "batchId")).put((Object)"DATA", (Object)Objects.requireNonNull(data, "data")).build());
    }

    @Override
    public void delete(@Nonnull Iterable<Long> ids) {
        Iterables.partition(ids, (int)500).forEach(batch -> this.ao.deleteWithSQL(AoUserNotification.class, batch.stream().map(id -> "?").collect(Collectors.joining(",", "ID IN (", ")")), batch.toArray()));
    }

    @Override
    public void streamBySenderId(@Nonnull String senderId, @Nonnull Consumer<AoUserNotification> callback) {
        Query orderedQuery = Query.select((String)"ID, USER_ID, DATE, BATCH_SENDER_ID, BATCH_ID, DATA").where("BATCH_SENDER_ID = ?", new Object[]{senderId}).order("USER_ID, BATCH_ID, DATE ASC");
        this.ao.stream(AoUserNotification.class, orderedQuery, callback::accept);
    }
}

