/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.commit.handlers;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.commit.CommitRequest;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.dmz.notification.commit.CommitDiscussionNotification;
import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.stash.internal.notification.handlers.AbstractNotificationHandler;
import com.atlassian.stash.internal.notification.handlers.NotificationHelper;
import com.atlassian.stash.internal.notification.handlers.WatchableMailThreadHeaderTransformer;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AbstractCommitDiscussionNotificationHandler<T extends CommitDiscussionNotification>
extends AbstractNotificationHandler<T> {
    public static final Pattern PATTERN_SUBJECT = Pattern.compile("(?:\\.\\s)|\n");
    private static final int SUMMARY_MAX_LENGTH = 100;
    private final CommitService commitService;

    public AbstractCommitDiscussionNotificationHandler(NotificationHelper helper, CommitService commitService, String templateName) {
        super(helper, templateName);
        this.commitService = commitService;
    }

    @Override
    protected Map<String, Object> getContext(T notification) {
        Map<String, Object> context = super.getContext(notification);
        context.put("commitDiscussion", notification.getCommitDiscussion());
        return context;
    }

    @Override
    protected I18nKey generateSubjectKey(CommitDiscussionNotification notification) {
        CommitDiscussion commitDiscussion = notification.getCommitDiscussion();
        Repository repository = commitDiscussion.getRepository();
        Commit commit = this.commitService.getCommit(new CommitRequest.Builder(repository, commitDiscussion.getCommitId()).build());
        return new I18nKey("bitbucket.notification.email.commitdiscussion.title", new Object[]{repository.getProject().getKey(), repository.getName(), commit.getDisplayId(), AbstractCommitDiscussionNotificationHandler.summarize(commit.getMessage())});
    }

    @Override
    protected Function<MailMessage.Builder, MailMessage.Builder> getMessageTransformer(CommitDiscussionNotification notification) {
        return new WatchableMailThreadHeaderTransformer((Watchable)notification.getCommitDiscussion());
    }

    @Override
    protected Set<SendMode> getEnabledSendModes() {
        return SendMode.batchedAndImmediateSet();
    }

    static String summarize(String message) {
        String summary;
        Matcher matcher = PATTERN_SUBJECT.matcher(message);
        String string = summary = matcher.find() ? message.substring(0, matcher.end()).trim() : message;
        if (summary.length() > 100) {
            summary = summary.substring(0, 100);
        }
        return summary;
    }
}

