/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.custom.pull;

import com.atlassian.bitbucket.dmz.notification.pull.custom.CustomNotificationData;
import com.atlassian.bitbucket.dmz.notification.pull.custom.CustomNotificationSection;
import com.atlassian.bitbucket.dmz.notification.pull.custom.CustomPullRequestNotificationEvent;
import com.atlassian.bitbucket.dmz.notification.pull.custom.CustomPullRequestNotificationRenderer;
import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.notification.batch.dao.UserNotificationDao;
import com.atlassian.stash.internal.notification.custom.pull.CustomPullRequestNotificationRendererAccessor;
import com.atlassian.stash.internal.notification.handlers.NotificationMailer;
import com.atlassian.stash.internal.notification.handlers.WatchableMailThreadHeaderTransformer;
import com.atlassian.stash.internal.notification.pull.PullRequestNotificationUtils;
import com.atlassian.stash.internal.notification.pull.activity.CustomData;
import com.atlassian.stash.internal.notification.pull.activity.PullRequestBatchId;
import com.atlassian.stash.internal.notification.usersettings.EmailNotificationSettings;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import com.atlassian.stash.internal.notification.usersettings.SendSettings;
import com.atlassian.stash.internal.notification.usersettings.UserNotificationSettingsService;
import com.atlassian.stash.internal.notification.util.MapUtils;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomPullRequestNotificationListener {
    private static final Logger log = LoggerFactory.getLogger(CustomPullRequestNotificationListener.class);
    private static final String TEMPLATE = "bitbucketPluginNotification.internal.feature.email.emailPullRequest.customSection";
    private final CustomPullRequestNotificationRendererAccessor rendererAccessor;
    private final NotificationMailer notificationMailer;
    private final SecurityService securityService;
    private final UserNotificationSettingsService settingsService;
    private final UserNotificationDao userNotificationDao;
    private final MailService mailService;

    public CustomPullRequestNotificationListener(CustomPullRequestNotificationRendererAccessor rendererAccessor, MailService mailService, NotificationMailer notificationMailer, SecurityService securityService, UserNotificationSettingsService settingsService, UserNotificationDao userNotificationDao) {
        this.rendererAccessor = rendererAccessor;
        this.mailService = mailService;
        this.notificationMailer = notificationMailer;
        this.securityService = securityService;
        this.settingsService = settingsService;
        this.userNotificationDao = userNotificationDao;
    }

    @EventListener
    public void onCustomEvent(CustomPullRequestNotificationEvent customEvent) {
        if (!this.mailService.isHostConfigured()) {
            log.debug("No mail configuration: discarding {} details: {}", (Object)customEvent.getClass().getSimpleName(), (Object)customEvent);
            return;
        }
        CustomPullRequestNotificationRenderer renderer = this.rendererAccessor.getRenderer(customEvent.getRendererId());
        if (renderer == null) {
            log.warn("No renderer with ID '{}' found for the custom notification event '{}', dropping event", (Object)customEvent.getRendererId(), (Object)customEvent);
            return;
        }
        MoreStreams.streamIterable((Iterable)customEvent.getRecipients()).collect(Collectors.groupingBy(recipient -> (SendMode)((Object)((Object)this.securityService.impersonating(recipient, "notification handling").call(() -> this.settingsService.getSettingsForUser((ApplicationUser)recipient).getEmailNotificationSettings().flatMap(EmailNotificationSettings::getPullRequestSendModeSettings).map(SendSettings::getSendMode).orElse(this.settingsService.getDefaultSendMode())))))).forEach((sendMode, recipients) -> {
            switch (sendMode) {
                case IMMEDIATE: {
                    this.sendNotifications(customEvent, renderer.render(customEvent.getPullRequest(), MapUtils.createMap(recipients, Collections.singleton(customEvent.getData()))));
                    break;
                }
                default: {
                    this.queueNotifications(customEvent, (Collection<ApplicationUser>)recipients, customEvent.getData());
                }
            }
        });
    }

    private void sendNotifications(CustomPullRequestNotificationEvent notificationEvent, Map<ApplicationUser, Collection<CustomNotificationSection>> customSections) {
        PullRequest pullRequest = notificationEvent.getPullRequest();
        I18nKey subjectKey = PullRequestNotificationUtils.createSubjectKey(pullRequest);
        customSections.forEach((user, sections) -> sections.stream().map(CustomNotificationSection::getContent).forEach(content -> this.notificationMailer.renderAndSend(notificationEvent, Collections.singleton(user), subjectKey, TEMPLATE, (Map<String, Object>)ImmutableMap.builder().put((Object)"pullRequest", (Object)pullRequest).put((Object)"moduleKey", (Object)"com.atlassian.bitbucket.server.bitbucket-notification:notification-email-styles").put((Object)"batchable", (Object)true).put((Object)"content", content).build(), new WatchableMailThreadHeaderTransformer((Watchable)pullRequest))));
    }

    private void queueNotifications(CustomPullRequestNotificationEvent notificationEvent, Collection<ApplicationUser> recipients, CustomNotificationData notificationData) {
        String encodedData;
        try {
            encodedData = new CustomData(notificationEvent.getRendererId(), notificationData.getData()).encode();
        }
        catch (IOException e) {
            log.error("Failed to encode data {}. Dropping custom notification", (Object)notificationData, (Object)e);
            return;
        }
        String batchId = PullRequestBatchId.of(notificationEvent.getPullRequest()).encode();
        recipients.stream().map(ApplicationUser::getId).forEach(recipient -> this.userNotificationDao.create((int)recipient, notificationEvent.getDate(), "PullRequest", batchId, encodedData));
    }
}

