/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.handlers;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.dmz.notification.Notification;
import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.notification.handlers.AbstractNotificationHandler;
import com.atlassian.stash.internal.notification.handlers.NotificationHelper;
import com.atlassian.stash.internal.notification.mention.MentionHelper;
import io.atlassian.fugue.Pair;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public abstract class AbstractMentionNotificationHandler<T extends Notification>
extends AbstractNotificationHandler<T> {
    protected final MentionHelper mentionHelper;
    protected final AbstractNotificationHandler<T> handler;

    public AbstractMentionNotificationHandler(NotificationHelper helper, MentionHelper mentionHelper, AbstractNotificationHandler<T> handler, String templateName) {
        super(helper, templateName);
        this.mentionHelper = mentionHelper;
        this.handler = handler;
    }

    @Override
    protected Map<String, Object> getContext(T notification) {
        Map<String, Object> context = this.handler.getContext(notification);
        context.put("mention", true);
        return context;
    }

    @Override
    public void handle(@Nonnull T notification, @Nonnull Iterable<ApplicationUser> recipients) {
        Pair<Iterable<ApplicationUser>, Set<ApplicationUser>> mentionedRecipients = this.mentionHelper.getFilteredRecipientsAndMentions((Notification)notification, this.getComment(notification), recipients);
        this.handler.handle(notification, (Iterable)mentionedRecipients.left());
        if (!((Set)mentionedRecipients.right()).isEmpty()) {
            this.renderAndDispatch(notification, this.getContext(notification), (Iterable)mentionedRecipients.right());
        }
    }

    @Override
    protected I18nKey generateSubjectKey(T notification) {
        return this.handler.generateSubjectKey(notification);
    }

    @Override
    protected Function<MailMessage.Builder, MailMessage.Builder> getMessageTransformer(T notification) {
        return this.handler.getMessageTransformer(notification);
    }

    protected abstract Comment getComment(T var1);
}

