/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.handlers;

import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.dmz.notification.Notification;
import com.atlassian.bitbucket.dmz.notification.NotificationHandler;
import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.watcher.WatchableVisitor;
import com.atlassian.bitbucket.watcher.Watcher;
import com.atlassian.stash.internal.notification.handlers.NotificationHelper;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import jakarta.annotation.Nonnull;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public abstract class AbstractNotificationHandler<T extends Notification>
implements NotificationHandler<T> {
    public static final String PLUGIN_PREFIX = "plugin.bitbucket-notification.";
    private final NotificationHelper helper;
    private final String templateName;

    protected AbstractNotificationHandler(NotificationHelper helper, String templateName) {
        this.helper = helper;
        this.templateName = templateName;
    }

    public void handle(@Nonnull T notification, @Nonnull Set<Watcher> watchers) {
        this.handle(notification, (Iterable)watchers.stream().filter(watcher -> (Boolean)watcher.getWatchable().accept((WatchableVisitor)new WatchableVisitor<Boolean>(this){

            public Boolean visit(@Nonnull CommitDiscussion discussion) {
                return true;
            }

            public Boolean visit(@Nonnull PullRequest pullRequest) {
                return true;
            }

            public Boolean visit(@Nonnull Repository repository) {
                return false;
            }
        })).map(Watcher::getUser).collect(MoreCollectors.toImmutableSet()));
    }

    protected void handle(@Nonnull T notification, @Nonnull Iterable<ApplicationUser> recipients) {
        this.renderAndDispatch(notification, this.getContext(notification), recipients);
    }

    protected void renderAndDispatch(T notification, Map<String, Object> context, Iterable<ApplicationUser> recipients) {
        Set<ApplicationUser> filteredRecipients = this.helper.filterByPullRequestSendMode(recipients, this.getEnabledSendModes());
        this.helper.renderAndSend(notification, filteredRecipients, this.generateSubjectKey(notification), this.templateName, context, this.getMessageTransformer(notification));
    }

    protected Map<String, Object> getContext(T notification) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        if (notification.getUser() != null) {
            context.put("user", notification.getUser());
        }
        context.put("date", notification.getTimestamp());
        context.put("moduleKey", "com.atlassian.bitbucket.server.bitbucket-notification:notification-email-styles");
        return context;
    }

    protected abstract I18nKey generateSubjectKey(T var1);

    protected abstract Function<MailMessage.Builder, MailMessage.Builder> getMessageTransformer(T var1);

    protected abstract Set<SendMode> getEnabledSendModes();
}

