/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.handlers;

import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.stash.internal.notification.handlers.NotificationMailer;
import com.atlassian.stash.internal.notification.usersettings.EmailNotificationSettings;
import com.atlassian.stash.internal.notification.usersettings.SendMode;
import com.atlassian.stash.internal.notification.usersettings.SendSettings;
import com.atlassian.stash.internal.notification.usersettings.UserNotificationSettingsService;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class NotificationHelper {
    private final NotificationMailer notificationMailer;
    private final SecurityService securityService;
    private final UserNotificationSettingsService userNotificationSettingsService;

    public NotificationHelper(NotificationMailer notificationMailer, SecurityService securityService, UserNotificationSettingsService userNotificationSettingsService) {
        this.notificationMailer = notificationMailer;
        this.securityService = securityService;
        this.userNotificationSettingsService = userNotificationSettingsService;
    }

    public <T> void renderAndSend(T notification, Iterable<ApplicationUser> recipients, I18nKey subjectKey, String templateName, Map<String, Object> templateData, Function<MailMessage.Builder, MailMessage.Builder> postProcess) {
        this.notificationMailer.renderAndSend(notification, recipients, subjectKey, templateName, templateData, postProcess);
    }

    public Set<ApplicationUser> filterByPullRequestSendMode(Iterable<ApplicationUser> recipients, Set<SendMode> sendModes) {
        return (Set)MoreStreams.streamIterable(recipients).filter(user -> sendModes.contains((Object)this.getPullRequestSendMode((ApplicationUser)user))).collect(MoreCollectors.toImmutableSet());
    }

    private SendMode getPullRequestSendMode(ApplicationUser user) {
        return (SendMode)((Object)this.securityService.impersonating(user, "retrieve notification settings").call(() -> this.userNotificationSettingsService.getSettingsForUser(user).getEmailNotificationSettings().flatMap(EmailNotificationSettings::getPullRequestSendModeSettings).map(SendSettings::getSendMode).orElse(this.userNotificationSettingsService.getDefaultSendMode())));
    }
}

