/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.handlers;

import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.mail.MailException;
import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.bitbucket.mail.SoyMailBuilder;
import com.atlassian.bitbucket.mail.SoyMailMessageRequest;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationMailer {
    public static final String SOY_EMAIL_TEMPLATE_MODULE = "com.atlassian.bitbucket.server.bitbucket-notification:notification-email-templates";
    public static final String EMAIL_STYLES_MODULE = "com.atlassian.bitbucket.server.bitbucket-notification:notification-email-styles";
    private static final Logger log = LoggerFactory.getLogger(NotificationMailer.class);
    private final MailService mailService;
    private final SoyMailBuilder soyMailBuilder;

    public NotificationMailer(MailService mailService, SoyMailBuilder soyMailBuilder) {
        this.mailService = mailService;
        this.soyMailBuilder = soyMailBuilder;
    }

    public <T> void renderAndSend(@Nonnull T notification, @Nonnull SoyMailMessageRequest soyMailMessageRequest) {
        Objects.requireNonNull(notification, "notification");
        Objects.requireNonNull(soyMailMessageRequest, "soyMailMessageRequest");
        this.buildAndSendMailMessages(notification, soyMailMessageRequest);
    }

    public <T> void renderAndSend(@Nonnull T notification, @Nonnull Iterable<ApplicationUser> recipients, @Nonnull I18nKey subjectKey, @Nonnull String templateName, @Nonnull Map<String, Object> templateData, @Nullable Function<MailMessage.Builder, MailMessage.Builder> postProcess) {
        this.buildAndSendMailMessages(notification, new SoyMailMessageRequest.Builder().cssModuleKey(EMAIL_STYLES_MODULE).context(templateData).messageEffector(postProcess).recipients(recipients).soyTemplateModuleKey(SOY_EMAIL_TEMPLATE_MODULE).soyTemplateName(templateName).subjectKey(subjectKey).build());
    }

    private <T> void buildAndSendMailMessages(T notification, SoyMailMessageRequest soyMailMessageRequest) {
        if (!this.mailService.isHostConfigured()) {
            log.debug("No mail configuration: discarding {} details: {}", (Object)notification.getClass().getSimpleName(), notification);
            return;
        }
        if (!Iterables.isEmpty((Iterable)soyMailMessageRequest.getRecipients())) {
            this.sendMailMessages(this.buildMessages(soyMailMessageRequest));
        }
    }

    private Iterable<MailMessage> buildMessages(SoyMailMessageRequest soyMailMessageRequest) {
        try (Timer ignored = TimerUtils.start((String)"Rendering soy messages");){
            Iterable iterable = this.soyMailBuilder.build(soyMailMessageRequest);
            return iterable;
        }
    }

    private void sendMailMessages(Iterable<MailMessage> messages) {
        try {
            for (MailMessage mail : messages) {
                this.mailService.submit(mail);
            }
        }
        catch (MailException mailException) {
            // empty catch block
        }
    }
}

