/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.handlers;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.commit.CommitDiscussion;
import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.bitbucket.watcher.WatchableVisitor;
import jakarta.annotation.Nonnull;
import java.util.function.Function;

public class WatchableMailThreadHeaderTransformer
implements Function<MailMessage.Builder, MailMessage.Builder> {
    public static final String IN_REPLY_TO_HEADER = "in-reply-to";
    public static final String MESSAGE_ID_HEADER = "message-id";
    public static final String REFERENCES_HEADER = "references";
    private static final String REPOSITORY_FORMAT = "%s-%s";
    private static final String REPOSITORY_OBJECT_FORMAT = "%s-%s-%s";
    private final String messageId;
    private final String replyTo;

    public WatchableMailThreadHeaderTransformer(Watchable watchable) {
        String formattedId = (String)watchable.accept((WatchableVisitor)new IdFormatWatchableVisitor());
        this.messageId = String.format("<%s-%3$d@%2$s>", formattedId, Product.NAME, System.nanoTime());
        this.replyTo = String.format("<%s@%s>", formattedId, Product.NAME);
    }

    @Override
    public MailMessage.Builder apply(MailMessage.Builder builder) {
        return builder.header(MESSAGE_ID_HEADER, this.messageId).header(IN_REPLY_TO_HEADER, this.replyTo).header(REFERENCES_HEADER, this.replyTo);
    }

    private static class IdFormatWatchableVisitor
    implements WatchableVisitor<String> {
        private IdFormatWatchableVisitor() {
        }

        public String visit(@Nonnull CommitDiscussion discussion) {
            return this.format(discussion.getRepository(), discussion.getCommitId());
        }

        public String visit(@Nonnull PullRequest pullRequest) {
            return this.format(pullRequest.getToRef().getRepository(), pullRequest.getId());
        }

        public String visit(@Nonnull Repository repository) {
            return this.format(repository);
        }

        private String format(Repository repository) {
            return this.format(repository, null);
        }

        private String format(Repository repository, Object id) {
            return String.format(id == null ? WatchableMailThreadHeaderTransformer.REPOSITORY_FORMAT : WatchableMailThreadHeaderTransformer.REPOSITORY_OBJECT_FORMAT, repository.getProject().getKey(), repository.getSlug(), id);
        }
    }
}

