/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.json;

import com.atlassian.bitbucket.json.JsonRenderer;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarRequestHelper;
import com.atlassian.bitbucket.rest.v2.api.enrich.LinkEnricher;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.stash.internal.notification.repository.model.RepositoryNotificationSettings;
import com.atlassian.stash.internal.notification.rest.repository.RestRepositoryNotificationSettings;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class RepositoryNotificationSettingsJsonRenderer
implements JsonRenderer {
    private final AvatarEnricher avatarEnricher;
    private final JsonFactory jsonFactory;
    private final LinkEnricher linkEnricher;
    private final RequestManager requestManager;

    public RepositoryNotificationSettingsJsonRenderer(AvatarEnricher avatarEnricher, LinkEnricher linkEnricher, RequestManager requestManager) {
        this.avatarEnricher = avatarEnricher;
        this.linkEnricher = linkEnricher;
        this.jsonFactory = new ObjectMapper().getFactory();
        this.requestManager = requestManager;
    }

    @Nullable
    public String render(@Nullable Object object, @Nonnull Map<String, Object> options) {
        String string;
        block11: {
            if (!(object instanceof Page)) {
                return null;
            }
            Page page = (Page)object;
            if (page.getSize() == 0) {
                return null;
            }
            if (!(page.getValues().iterator().next() instanceof RepositoryNotificationSettings)) {
                return null;
            }
            RestPage restPage = new RestPage(page, s -> {
                RestRepositoryNotificationSettings surrogate = new RestRepositoryNotificationSettings((RepositoryNotificationSettings)s);
                this.avatarEnricher.enrich((Object)surrogate, AvatarRequestHelper.makeAvatarRequest((RequestManager)this.requestManager, (Map)options));
                this.linkEnricher.enrich((Object)surrogate);
                return surrogate;
            });
            StringWriter writer = new StringWriter();
            JsonGenerator generator = this.jsonFactory.createJsonGenerator((Writer)writer);
            try {
                generator.writeObject((Object)restPage);
                generator.flush();
                string = writer.toString();
                if (generator == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (generator != null) {
                        try {
                            generator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            generator.close();
        }
        return string;
    }
}

