/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.mention;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.dmz.notification.Notification;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserMentionScanner;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreStreams;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Pair;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class MentionHelper {
    public static final String MENTIONS_ENABLED = "mentions.enabled";
    private static final int MAX_MENTIONS_DEFAULT = 200;
    private static final String PROPERTY_MAX_MENTIONS = "plugin.bitbucket-notification.max.mentions";
    private final ApplicationPropertiesService propertiesService;
    private final int maxMentions;
    private final UserMentionScanner mentionScanner;
    private final UserService userService;
    private final Predicate<ApplicationUser> isLicensedUser;

    public MentionHelper(ApplicationPropertiesService propertiesService, UserMentionScanner mentionScanner, UserService userService, PermissionService permissionService) {
        this(propertiesService, mentionScanner, userService, user -> permissionService.hasGlobalPermission(user, Permission.LICENSED_USER), propertiesService.getPluginProperty(PROPERTY_MAX_MENTIONS, 200));
    }

    public MentionHelper(ApplicationPropertiesService propertiesService, UserMentionScanner mentionScanner, UserService userService, Predicate<ApplicationUser> isLicensedUser, int maxMentions) {
        this.propertiesService = propertiesService;
        this.maxMentions = maxMentions;
        this.mentionScanner = mentionScanner;
        this.userService = userService;
        this.isLicensedUser = isLicensedUser;
    }

    public Set<ApplicationUser> findUsers(@Nonnull Notification notification, @Nullable CharSequence text) {
        if (text == null) {
            return Collections.emptySet();
        }
        return this.findUsers(notification, this.mentionScanner.getMentionedUsers(text, this.maxMentions));
    }

    public Set<ApplicationUser> findUsers(@Nonnull Notification notification, @Nonnull Set<String> mentionedUsers) {
        return Chainable.chain((Iterable)this.userService.getUsersByName(mentionedUsers)).filter(mentionedUser -> !Objects.equals(mentionedUser, notification.getUser())).filter(this.isLicensedUser).toSet();
    }

    public Set<String> getMentionedUsersDifference(@Nullable CharSequence previousText, @Nullable CharSequence text) {
        return Sets.difference(this.getMentionedUsers(text), this.getMentionedUsers(previousText));
    }

    public Set<String> getMentionedUsers(@Nullable CharSequence text) {
        if (text == null) {
            return Collections.emptySet();
        }
        return this.mentionScanner.getMentionedUsers(text, this.maxMentions);
    }

    public Pair<Iterable<ApplicationUser>, Set<ApplicationUser>> getFilteredRecipientsAndMentions(Notification notification, Comment comment, Iterable<ApplicationUser> recipients) {
        if (!this.getProperty(MENTIONS_ENABLED, false)) {
            return Pair.pair(recipients, Collections.emptySet());
        }
        Set<ApplicationUser> mentionedUsers = this.findUsers(notification, this.getMentionedUsers(comment));
        return Pair.pair((Object)((Iterable)MoreStreams.streamIterable(recipients).filter(recipient -> !mentionedUsers.contains(recipient)).collect(MoreCollectors.toImmutableList())), mentionedUsers);
    }

    protected Set<String> getMentionedUsers(Comment comment) {
        return this.mentionScanner.getMentionedUsers((CharSequence)comment.getText(), this.maxMentions);
    }

    private boolean getProperty(String name, boolean defaultValue) {
        return this.propertiesService.getPluginProperty("plugin.bitbucket-notification." + name, defaultValue);
    }
}

