/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.mention;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.dmz.markup.renderer.MarkupRendererComponent;
import com.atlassian.bitbucket.dmz.markup.renderer.RenderContext;
import com.atlassian.bitbucket.dmz.markup.renderer.RenderTransform;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserMentionScanner;
import com.atlassian.bitbucket.user.UserService;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;

public class MentionRendererComponent
implements MarkupRendererComponent {
    private final AuthenticationContext authenticationContext;
    private final ThreadLocal<Map<String, String>> requestCache;
    private final UserMentionScanner mentionScanner;
    private final RequestContext requestContext;
    private final UserService userService;

    public MentionRendererComponent(AuthenticationContext authenticationContext, UserMentionScanner mentionScanner, final RequestContext requestContext, UserService userService) {
        this.authenticationContext = authenticationContext;
        this.mentionScanner = mentionScanner;
        this.requestContext = requestContext;
        this.userService = userService;
        this.requestCache = new ThreadLocal<Map<String, String>>(){

            @Override
            protected Map<String, String> initialValue() {
                if (requestContext.isActive()) {
                    requestContext.addCleanupCallback(new Runnable(){

                        @Override
                        public void run() {
                            MentionRendererComponent.this.requestCache.remove();
                        }
                    });
                }
                return Maps.newHashMap();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public RenderTransform process(@Nonnull CharSequence input, @Nonnull RenderContext context) {
        try {
            RenderTransform.TransformBuilder builder = RenderTransform.builder();
            this.mentionScanner.processMentions(input, userMention -> {
                String rendered = this.getOrRender(userMention.getUsername(), userMention.getFullUnescapedMention());
                builder.add(userMention.getStart(), userMention.getEnd(), rendered);
            });
            RenderTransform renderTransform = builder.build();
            return renderTransform;
        }
        finally {
            if (!this.requestContext.isActive()) {
                this.requestCache.remove();
            }
        }
    }

    private String getOrRender(String name, String fullMention) {
        Map<String, String> cache = this.requestCache.get();
        String rendered = cache.get(fullMention);
        if (rendered == null) {
            ApplicationUser user = this.userService.getUserByName(name);
            rendered = user == null ? StringEscapeUtils.escapeHtml4((String)fullMention) : this.renderMention(user.getDisplayName(), this.isCurrentUser(name));
            cache.put(fullMention, rendered);
        }
        return rendered;
    }

    private boolean isCurrentUser(String mentionGroup) {
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        return currentUser != null && mentionGroup.equals(currentUser.getName());
    }

    private String renderMention(String mention, boolean currentUser) {
        return String.format("<span class=\"user-mention %s\">%s</span>", currentUser ? "current-user" : "", StringEscapeUtils.escapeHtml4((String)mention));
    }
}

