/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.pull.activity;

import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.notification.pull.activity.AbstractBatchEmailActivity;
import com.atlassian.stash.internal.notification.pull.activity.BatchEmailActivityType;
import com.atlassian.stash.internal.notification.pull.activity.CommentThread;
import com.atlassian.stash.internal.notification.pull.activity.CommentThreadCollection;
import com.atlassian.stash.internal.notification.pull.activity.DiffAnchorInfo;
import com.atlassian.stash.internal.notification.util.AnchorUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BatchEmailActivityFile
extends AbstractBatchEmailActivity {
    private final Map<DiffAnchorInfo, CommentThreadCollection> comments = new TreeMap<DiffAnchorInfo, CommentThreadCollection>();
    private final CommentThreadDiffAnchorType diffType;
    private final String name;
    private final String path;
    private final String fromHash;
    private final String toHash;

    public BatchEmailActivityFile(CommentThreadDiffAnchor anchor) {
        this.path = AnchorUtils.getFilePath(anchor);
        this.name = AnchorUtils.getFileName(anchor);
        this.fromHash = anchor.getFromHash().orElse(null);
        this.toHash = anchor.getToHash();
        this.diffType = anchor.getDiffType();
    }

    @Nonnull
    public CommentThreadCollection getCommentThreadCollection(@Nonnull DiffAnchorInfo anchor) {
        return this.comments.computeIfAbsent(Objects.requireNonNull(anchor, "anchor"), a -> new CommentThreadCollection());
    }

    @Override
    @Nonnull
    public Date getDate() {
        return BatchEmailActivityFile.getDateOfOldestNonContextComment(this.comments.values());
    }

    @Override
    @Nonnull
    public BatchEmailActivityType getType() {
        return BatchEmailActivityType.FILE;
    }

    @Override
    void populateData(ImmutableMap.Builder<String, Object> dataBuilder) {
        Set<ApplicationUser> authors = this.getAuthors();
        dataBuilder.put((Object)"path", (Object)this.path).put((Object)"name", (Object)this.name).put((Object)"fromHash", (Object)this.fromHash).put((Object)"toHash", (Object)this.toHash).put((Object)"authorCount", (Object)authors.size()).put((Object)"diffType", (Object)this.diffType).put((Object)"lines", this.getLines()).put((Object)"firstAuthor", Iterables.getFirst(authors, null));
    }

    private static Date getDateOfOldestNonContextComment(Iterable<CommentThreadCollection> threadCollections) {
        Ordering ordering = Ordering.natural().nullsLast();
        CommentThread oldest = null;
        for (CommentThreadCollection threadCollection : threadCollections) {
            for (CommentThread thread : threadCollection.getThreads()) {
                CommentThread candidate = thread.isContext() ? (CommentThread)ordering.min(thread.getReplies()) : thread;
                oldest = (CommentThread)ordering.min((Object)oldest, (Object)candidate);
            }
        }
        if (oldest == null) {
            throw new IllegalStateException("File without any non-context comments");
        }
        return oldest.getDate();
    }

    private Set<ApplicationUser> getAuthors() {
        return this.getLines().stream().flatMap(FileLineData::getAuthors).collect(Collectors.toSet());
    }

    private List<FileLineData> getLines() {
        return (List)this.comments.entrySet().stream().map(entry -> new FileLineData((DiffAnchorInfo)entry.getKey(), (CommentThreadCollection)entry.getValue())).collect(MoreCollectors.toImmutableList());
    }

    public static class FileLineData {
        private final DiffAnchorInfo anchorInfo;
        private final CommentThreadCollection commentsCollection;

        public FileLineData(DiffAnchorInfo anchorInfo, CommentThreadCollection commentsCollection) {
            this.anchorInfo = anchorInfo;
            this.commentsCollection = commentsCollection;
        }

        @Nonnull
        public Stream<ApplicationUser> getAuthors() {
            return this.getThreads().stream().flatMap(FileLineData::getThreadAuthors);
        }

        public int getLine() {
            if (this.anchorInfo.isLineComment()) {
                DiffSegmentType type = this.anchorInfo.getLineType();
                return type.isInSource() ? this.anchorInfo.getSourceLine() : this.anchorInfo.getDestinationLine();
            }
            return 0;
        }

        public DiffSegmentType getType() {
            return this.anchorInfo.getLineType();
        }

        public String getText() {
            return this.anchorInfo.getText();
        }

        @Nonnull
        public Collection<CommentThread> getThreads() {
            return this.commentsCollection.getThreads();
        }

        private static Stream<ApplicationUser> getThreadAuthors(CommentThread commentThread) {
            Stream myAuthor = commentThread.isContext() ? Stream.empty() : Stream.of(commentThread.getComment().getAuthor());
            Stream replyAuthors = commentThread.getReplies().stream().flatMap(FileLineData::getThreadAuthors);
            return Stream.concat(myAuthor, replyAuthors);
        }
    }
}

