/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.pull.activity;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.stash.internal.notification.batch.Data;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;

public class CommentData
extends Data {
    private static final String COMMENT_KEY = "comment";
    private static final String ROOT_COMMENT_KEY = "rootComment";
    private final long commentId;
    private final Long rootCommentId;

    public CommentData(Comment comment) {
        this(comment.getId(), comment.getThread().getRootComment().getId());
    }

    private CommentData(long commentId, Long rootCommentId) {
        this.commentId = commentId;
        this.rootCommentId = rootCommentId;
    }

    public long getCommentId() {
        return this.commentId;
    }

    public Optional<Long> getRootCommentId() {
        return Optional.ofNullable(this.rootCommentId);
    }

    @Override
    public String encode() throws IOException {
        return DATA_MAPPER.write((Map<String, ?>)ImmutableMap.of((Object)COMMENT_KEY, (Object)this.commentId, (Object)ROOT_COMMENT_KEY, (Object)this.rootCommentId));
    }

    @Nullable
    public static CommentData tryDecode(Map<String, ?> map) {
        Object comment = map.get(COMMENT_KEY);
        Object rootComment = map.get(ROOT_COMMENT_KEY);
        if (comment instanceof Number) {
            return new CommentData(((Number)comment).longValue(), rootComment == null ? null : Long.valueOf(((Number)rootComment).longValue()));
        }
        return null;
    }
}

