/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.pull.activity;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.stash.internal.notification.pull.activity.AbstractBatchEmailActivity;
import com.atlassian.stash.internal.notification.pull.activity.BatchEmailActivityType;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;

public class CommentThread
extends AbstractBatchEmailActivity
implements Comparable<CommentThread> {
    private static final String CONTEXT_KEY = "context";
    private static final String COMMENT_KEY = "comment";
    private static final String REPLIES_KEY = "replies";
    private final boolean isContext;
    private final SortedSet<CommentThread> replies = new TreeSet<CommentThread>();
    private final Comment comment;
    private final Date date;

    public CommentThread(@Nonnull Comment comment, boolean isContext) {
        this.comment = Objects.requireNonNull(comment, COMMENT_KEY);
        this.isContext = isContext;
        this.date = comment.getCreatedDate();
    }

    @Nonnull
    public CommentThread addReply(@Nonnull CommentThread commentThread) {
        this.replies.add(Objects.requireNonNull(commentThread, "commentThread"));
        return commentThread;
    }

    @Nonnull
    public Comment getComment() {
        return this.comment;
    }

    @Override
    @Nonnull
    public Date getDate() {
        return this.date;
    }

    @Nonnull
    public Collection<CommentThread> getReplies() {
        return Collections.unmodifiableSet(this.replies);
    }

    @Override
    @Nonnull
    public BatchEmailActivityType getType() {
        return BatchEmailActivityType.COMMENT_THREAD;
    }

    public boolean isContext() {
        return this.isContext;
    }

    @Override
    public int compareTo(@Nonnull CommentThread other) {
        return ComparisonChain.start().compare((Comparable)this.date, (Comparable)other.date).compare(this.comment.getId(), other.comment.getId()).result();
    }

    @Override
    void populateData(ImmutableMap.Builder<String, Object> dataBuilder) {
        dataBuilder.put((Object)CONTEXT_KEY, (Object)this.isContext);
        dataBuilder.put((Object)COMMENT_KEY, (Object)this.comment);
        dataBuilder.put((Object)REPLIES_KEY, this.getReplies());
    }
}

