/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.pull.activity;

import com.atlassian.stash.internal.notification.batch.Data;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class CustomData
extends Data {
    private static final String CUSTOM_RENDERER_KEY = "customRenderer";
    private static final String CUSTOM_DATA_KEY = "customData";
    private final String rendererId;
    private final Map<String, Object> data;

    public CustomData(@Nonnull String rendererId, @Nonnull Map<String, Object> data) {
        this.rendererId = Objects.requireNonNull(rendererId, "rendererId");
        this.data = Objects.requireNonNull(data, "data");
    }

    @Nonnull
    public String getRendererId() {
        return this.rendererId;
    }

    @Nonnull
    public Map<String, Object> getData() {
        return this.data;
    }

    @Override
    public String encode() throws IOException {
        ImmutableMap map = ImmutableMap.of((Object)CUSTOM_RENDERER_KEY, (Object)this.rendererId, (Object)CUSTOM_DATA_KEY, this.data);
        return DATA_MAPPER.write((Map<String, ?>)map);
    }

    @Nullable
    public static CustomData tryDecode(Map<String, ?> map) {
        Object customRenderer = map.get(CUSTOM_RENDERER_KEY);
        Object customDataObject = map.get(CUSTOM_DATA_KEY);
        if (customRenderer instanceof String && customDataObject instanceof Map) {
            Map customData = (Map)customDataObject;
            return new CustomData((String)customRenderer, customData);
        }
        return null;
    }
}

