/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.pull.activity;

import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.content.Diff;
import com.atlassian.bitbucket.content.DiffHunk;
import com.atlassian.bitbucket.content.DiffLine;
import com.atlassian.bitbucket.content.DiffSegment;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.stash.internal.notification.util.BidiUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Comparator;
import java.util.Objects;

final class DiffAnchorInfo
implements Comparable<DiffAnchorInfo> {
    private final int sourceLine;
    private final int destinationLine;
    private final DiffSegmentType lineType;
    private final String text;

    @VisibleForTesting
    DiffAnchorInfo(int sourceLine, int destinationLine, @Nullable DiffSegmentType lineType, @Nonnull String text) {
        this.sourceLine = sourceLine;
        this.destinationLine = destinationLine;
        this.lineType = lineType;
        this.text = BidiUtils.replaceBidi(text);
    }

    static DiffAnchorInfo create(CommentThreadDiffAnchor anchor, Diff diff) {
        int lineNumber = anchor.getLine();
        return anchor.getLineType().map(type -> DiffAnchorInfo.findAnchorInDiff(diff, type, lineNumber)).orElseGet(() -> new DiffAnchorInfo(lineNumber, lineNumber, anchor.getLineType().orElse(null), ""));
    }

    public int getSourceLine() {
        return this.sourceLine;
    }

    public int getDestinationLine() {
        return this.destinationLine;
    }

    public boolean isLineComment() {
        return this.lineType != null;
    }

    @Nullable
    public DiffSegmentType getLineType() {
        return this.lineType;
    }

    @Nonnull
    public String getText() {
        return this.text;
    }

    @Override
    public int compareTo(DiffAnchorInfo o) {
        return ComparisonChain.start().compare(this.sourceLine, o.sourceLine).compare(this.destinationLine, o.destinationLine).compare((Object)this.lineType, (Object)o.lineType, (Comparator)Ordering.natural().nullsFirst()).compare((Comparable)((Object)this.text), (Comparable)((Object)o.text)).result();
    }

    public int hashCode() {
        return Objects.hash(this.sourceLine, this.destinationLine, this.lineType, this.text);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DiffAnchorInfo)) {
            return false;
        }
        DiffAnchorInfo that = (DiffAnchorInfo)obj;
        return this.sourceLine == that.sourceLine && this.destinationLine == that.destinationLine && Objects.equals(this.lineType, that.lineType) && Objects.equals(this.text, that.text);
    }

    @Nullable
    private static DiffAnchorInfo findAnchorInDiff(@Nullable Diff diff, @Nonnull DiffSegmentType lineType, int lineNumber) {
        if (diff != null) {
            for (DiffHunk hunk : diff.getHunks()) {
                for (DiffSegment segment : hunk.getSegments()) {
                    if (segment.getType() != lineType) continue;
                    for (DiffLine line : segment.getLines()) {
                        int checkLineNumber = lineType.isInSource() ? line.getSource() : line.getDestination();
                        if (lineNumber != checkLineNumber) continue;
                        return new DiffAnchorInfo(line.getSource(), line.getDestination(), lineType, line.getLine());
                    }
                }
            }
        }
        return null;
    }
}

