/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.pull.activity;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchor;
import com.atlassian.bitbucket.comment.CommentThreadDiffAnchorType;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.dmz.notification.pull.custom.CustomNotificationSection;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestActivityVisitor;
import com.atlassian.bitbucket.pull.PullRequestAutoMergeCancelledActivity;
import com.atlassian.bitbucket.pull.PullRequestCommentActivity;
import com.atlassian.bitbucket.pull.PullRequestDraftStatusUpdatedActivity;
import com.atlassian.bitbucket.pull.PullRequestMergeActivity;
import com.atlassian.bitbucket.pull.PullRequestRescopeActivity;
import com.atlassian.bitbucket.pull.PullRequestReviewersUpdatedActivity;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.notification.pull.activity.BatchEmailActivity;
import com.atlassian.stash.internal.notification.pull.activity.BatchEmailActivityFile;
import com.atlassian.stash.internal.notification.pull.activity.BatchEmailActivityType;
import com.atlassian.stash.internal.notification.pull.activity.CommentThread;
import com.atlassian.stash.internal.notification.pull.activity.CommentThreadCollection;
import com.atlassian.stash.internal.notification.pull.activity.DiffAnchorInfo;
import com.atlassian.stash.internal.notification.pull.activity.ToBranchUpdate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public class PullRequestActivityRenderContext {
    private final Map<String, Long> counts;
    private final PullRequest pullRequest;
    private final List<Map<String, Object>> sortedItems;
    private final boolean truncated;

    private PullRequestActivityRenderContext(Builder builder) {
        this.counts = ImmutableMap.copyOf(builder.counts);
        this.pullRequest = builder.pullRequest;
        Stream itemStream = ImmutableList.builder().addAll((Iterable)builder.items.build()).addAll((Iterable)builder.fileActivities.values().stream().map(BatchEmailActivity::asData).collect(MoreCollectors.toImmutableList())).addAll((Iterable)builder.commentThreads.getThreads().stream().map(BatchEmailActivity::asData).collect(MoreCollectors.toImmutableList())).build().stream().sorted((m1, m2) -> Comparator.nullsLast(Comparator.comparingLong(Date::getTime)).compare((Date)m1.get("date"), (Date)m2.get("date")));
        if (builder.limit != null) {
            itemStream = itemStream.limit(builder.limit + 1);
        }
        List items = (List)itemStream.collect(MoreCollectors.toImmutableList());
        this.truncated = builder.limit != null && items.size() > builder.limit;
        this.sortedItems = this.truncated ? items.subList(0, builder.limit) : items;
    }

    @Nonnull
    public Map<String, Long> getCounts() {
        return this.counts;
    }

    @Nonnull
    public PullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Nonnull
    public List<Map<String, Object>> getSortedItems() {
        return this.sortedItems;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public static class Builder {
        private static final int MAX_COMMITS_ON_RESCOPE = 5;
        private static final String ACTION_KEY = "action";
        private static final String ACTIVITY_ID_KEY = "activityId";
        private static final String ADDED_REVIEWERS_KEY = "addedReviewers";
        private static final String AUTHORS_KEY = "authors";
        private static final String AUTO_MERGE_KEY = "autoMerge";
        private static final String CHANGES_KEY = "changes";
        private static final String COMMITS_KEY = "commits";
        private static final String COMMITS_REMOVED_KEY = "commitsRemoved";
        private static final String CONTENT_KEY = "content";
        private static final String DATE_KEY = "date";
        private static final String DRAFT_KEY = "draft";
        private static final String REMOVED_REVIEWERS_KEY = "removedReviewers";
        private static final String REASON = "reason";
        private static final String TO_BRANCH_KEY = "toBranch";
        private static final String TYPE_KEY = "type";
        private static final String USER_KEY = "user";
        private static final String COMMENT_COUNT_KEY = PullRequestAction.COMMENTED.toString().toLowerCase(Locale.US);
        private static final String PUSH_COUNT_KEY = PullRequestAction.RESCOPED.toString().toLowerCase(Locale.US);
        private final ImmutableSet<Long> commentIds;
        private final CommentThreadCollection commentThreads;
        private final Map<String, Long> counts;
        private final Map<String, BatchEmailActivityFile> fileActivities;
        private final ImmutableList.Builder<Map<String, Object>> items;
        private final Set<Long> processedCommentIds;
        private final PullRequest pullRequest;
        private final Set<PullRequestAction> workflowActions;
        private Integer limit;

        public Builder(@Nonnull Set<Long> commentIds, @Nonnull PullRequest pullRequest, @Nonnull Set<PullRequestAction> workflowActions) {
            this.commentIds = ImmutableSet.copyOf((Collection)Objects.requireNonNull(commentIds, "commentIds"));
            this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
            this.workflowActions = Objects.requireNonNull(workflowActions, "workflowActions");
            this.commentThreads = new CommentThreadCollection();
            this.counts = new HashMap<String, Long>();
            this.fileActivities = new HashMap<String, BatchEmailActivityFile>();
            this.items = ImmutableList.builder();
            this.processedCommentIds = new HashSet<Long>();
        }

        @Nonnull
        public Builder activities(@Nonnull Iterable<PullRequestActivity> values) {
            Objects.requireNonNull(values, "activities");
            values.forEach(this::activity);
            return this;
        }

        @Nonnull
        public Builder activity(@Nonnull PullRequestActivity value) {
            Objects.requireNonNull(value, "activity");
            value.accept(new PullRequestActivityVisitor(){

                public void visit(@Nonnull PullRequestActivity activity) {
                    if (workflowActions.contains(activity.getAction())) {
                        this.addWorkflowActivity(activity);
                    }
                }

                public void visit(@Nonnull PullRequestCommentActivity activity) {
                    this.addCommentActivity(activity);
                }

                public void visit(@Nonnull PullRequestDraftStatusUpdatedActivity activity) {
                    this.addDraftStatusUpdatedActivity(activity);
                }

                public void visit(@Nonnull PullRequestMergeActivity activity) {
                    this.addMergeActivity(activity);
                }

                public void visit(@Nonnull PullRequestRescopeActivity activity) {
                    this.addRescopeActivity(activity);
                }

                public void visit(@Nonnull PullRequestReviewersUpdatedActivity activity) {
                    this.addReviewersUpdatedActivity(activity);
                }

                public void visit(@Nonnull PullRequestAutoMergeCancelledActivity activity) {
                    this.addAutoMergeCancelledActivity(activity);
                }
            });
            return this;
        }

        @Nonnull
        public PullRequestActivityRenderContext build() {
            return new PullRequestActivityRenderContext(this);
        }

        @Nonnull
        public Builder customSection(@Nonnull CustomNotificationSection value) {
            ImmutableMap.Builder item = ImmutableMap.builder().put((Object)CONTENT_KEY, (Object)value.getContent()).put((Object)TYPE_KEY, (Object)BatchEmailActivityType.CUSTOM_SECTION);
            Date date = value.getDate();
            if (date != null) {
                item.put((Object)DATE_KEY, (Object)date);
            }
            this.items.add((Object)item.build());
            return this;
        }

        @Nonnull
        public Builder customSections(@Nonnull Iterable<CustomNotificationSection> values) {
            Objects.requireNonNull(values, "customNotificationSections");
            values.forEach(this::customSection);
            return this;
        }

        @Nonnull
        public Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        @Nonnull
        public Builder toBranchUpdate(@Nonnull ToBranchUpdate value) {
            ImmutableMap item = ImmutableMap.builder().put((Object)TYPE_KEY, (Object)BatchEmailActivityType.TO_BRANCH_UPDATE).put((Object)USER_KEY, (Object)value.getUser()).put((Object)DATE_KEY, (Object)value.getDate()).put((Object)TO_BRANCH_KEY, (Object)value.getToBranch()).build();
            this.items.add((Object)item);
            return this;
        }

        @Nonnull
        public Builder toBranchUpdates(@Nonnull Iterable<ToBranchUpdate> values) {
            Objects.requireNonNull(values, "toBranchUpdates");
            values.forEach(this::toBranchUpdate);
            return this;
        }

        private static String getFileCommentActivityKey(CommentThreadDiffAnchor anchor) {
            StringBuilder key = new StringBuilder(anchor.getPath());
            if (anchor.getDiffType() != CommentThreadDiffAnchorType.EFFECTIVE) {
                key.append(':');
                anchor.getFromHash().ifPresent(key::append);
                key.append(':').append(anchor.getToHash());
            }
            return key.toString();
        }

        private void addCommentActivity(PullRequestCommentActivity rootCommentActivity) {
            CommentThreads commentThreads = CommentThreads.build(rootCommentActivity.getComment(), (Set<Long>)Sets.difference(this.commentIds, this.processedCommentIds));
            if (!commentThreads.getThreads().isEmpty()) {
                CommentThreadCollection collection = this.getCommentThreadCollection(rootCommentActivity);
                commentThreads.getThreads().forEach(collection::add);
                Set<Long> addedCommentIds = commentThreads.getCommentIdsInThreads();
                this.addCount(COMMENT_COUNT_KEY, addedCommentIds.size());
                this.processedCommentIds.addAll(addedCommentIds);
            }
        }

        private void addDraftStatusUpdatedActivity(PullRequestDraftStatusUpdatedActivity activity) {
            this.items.add((Object)ImmutableMap.builder().put((Object)ACTIVITY_ID_KEY, (Object)activity.getId()).put((Object)DATE_KEY, (Object)activity.getCreatedDate()).put((Object)DRAFT_KEY, (Object)activity.isDraft()).put((Object)TYPE_KEY, (Object)BatchEmailActivityType.DRAFT_STATUS_UPDATED).put((Object)USER_KEY, (Object)activity.getUser()).build());
            this.addCount(activity.getAction().toString().toLowerCase(Locale.US), 1L);
        }

        private void addMergeActivity(PullRequestMergeActivity activity) {
            this.items.add((Object)ImmutableMap.builder().put((Object)ACTION_KEY, (Object)activity.getAction().toString()).put((Object)ACTIVITY_ID_KEY, (Object)activity.getId()).put((Object)AUTO_MERGE_KEY, (Object)activity.isAutoMerge()).put((Object)DATE_KEY, (Object)activity.getCreatedDate()).put((Object)TYPE_KEY, (Object)BatchEmailActivityType.WORKFLOW).put((Object)USER_KEY, (Object)activity.getUser()).build());
            this.addCount(activity.getAction().toString().toLowerCase(Locale.US), 1L);
        }

        private void addRescopeActivity(PullRequestRescopeActivity activity) {
            Set authors = (Set)Stream.concat(activity.getAdded().getCommits().stream(), activity.getRemoved().getCommits().stream()).map(Commit::getAuthor).collect(MoreCollectors.toImmutableSet());
            Page commits = PageUtils.createPage((Iterable)activity.getAdded().getCommits(), (activity.getAdded().getTotal() <= 5 ? 1 : 0) != 0, (PageRequest)PageUtils.newRequest((int)0, (int)5));
            int remaining = Math.max(0, 5 - commits.getSize());
            Page removedCommits = PageUtils.createPage((Iterable)activity.getRemoved().getCommits(), (activity.getRemoved().getTotal() <= remaining ? 1 : 0) != 0, (PageRequest)PageUtils.newRequest((int)0, (int)remaining));
            this.items.add((Object)ImmutableMap.builder().put((Object)ACTIVITY_ID_KEY, (Object)activity.getId()).put((Object)AUTHORS_KEY, (Object)authors.size()).put((Object)CHANGES_KEY, (Object)(activity.getAdded().getTotal() + activity.getRemoved().getTotal())).put((Object)COMMITS_KEY, (Object)commits).put((Object)COMMITS_REMOVED_KEY, (Object)removedCommits).put((Object)DATE_KEY, (Object)activity.getCreatedDate()).put((Object)TYPE_KEY, (Object)BatchEmailActivityType.RESCOPE).put((Object)USER_KEY, (Object)activity.getUser()).build());
            this.addCount(PUSH_COUNT_KEY, 1L);
        }

        private void addReviewersUpdatedActivity(PullRequestReviewersUpdatedActivity activity) {
            this.items.add((Object)ImmutableMap.builder().put((Object)ACTIVITY_ID_KEY, (Object)activity.getId()).put((Object)ADDED_REVIEWERS_KEY, (Object)activity.getAddedReviewers()).put((Object)REMOVED_REVIEWERS_KEY, (Object)activity.getRemovedReviewers()).put((Object)DATE_KEY, (Object)activity.getCreatedDate()).put((Object)TYPE_KEY, (Object)BatchEmailActivityType.REVIEWERS_UPDATED).put((Object)USER_KEY, (Object)activity.getUser()).build());
            this.addCount(activity.getAction().toString().toLowerCase(Locale.US), 1L);
        }

        private void addAutoMergeCancelledActivity(PullRequestAutoMergeCancelledActivity activity) {
            ApplicationUser user = activity.getUser();
            this.items.add((Object)ImmutableMap.builder().put((Object)ACTION_KEY, (Object)activity.getAction().toString()).put((Object)ACTIVITY_ID_KEY, (Object)activity.getId()).put((Object)DATE_KEY, (Object)activity.getCreatedDate()).put((Object)REASON, (Object)activity.getCancelledReason()).put((Object)TYPE_KEY, (Object)BatchEmailActivityType.WORKFLOW).put((Object)USER_KEY, (Object)user).build());
            this.addCount(activity.getAction().toString().toLowerCase(Locale.US), 1L);
        }

        private void addWorkflowActivity(PullRequestActivity activity) {
            this.items.add((Object)ImmutableMap.builder().put((Object)ACTION_KEY, (Object)activity.getAction().toString()).put((Object)ACTIVITY_ID_KEY, (Object)activity.getId()).put((Object)DATE_KEY, (Object)activity.getCreatedDate()).put((Object)TYPE_KEY, (Object)BatchEmailActivityType.WORKFLOW).put((Object)USER_KEY, (Object)activity.getUser()).build());
            this.addCount(activity.getAction().toString().toLowerCase(Locale.US), 1L);
        }

        private void addCount(String key, long toAdd) {
            this.counts.compute(key, (k, value) -> value == null ? toAdd : value + toAdd);
        }

        private CommentThreadCollection getCommentThreadCollection(PullRequestCommentActivity rootCommentActivity) {
            return rootCommentActivity.getComment().getAnchor().map(anchor -> {
                BatchEmailActivityFile fileActivity = this.fileActivities.computeIfAbsent(Builder.getFileCommentActivityKey(anchor), key -> new BatchEmailActivityFile((CommentThreadDiffAnchor)anchor));
                DiffAnchorInfo anchorInfo = DiffAnchorInfo.create(anchor, rootCommentActivity.getDiff().orElse(null));
                return fileActivity.getCommentThreadCollection(anchorInfo);
            }).orElse(this.commentThreads);
        }

        private static class CommentThreads {
            private final Set<CommentThread> threads;
            private final Set<Long> commentIdsInThreads;
            private final Set<Long> includedCommentIds;

            private CommentThreads(Set<Long> includedCommentIds) {
                this.includedCommentIds = includedCommentIds;
                this.threads = new HashSet<CommentThread>();
                this.commentIdsInThreads = new HashSet<Long>();
            }

            public static CommentThreads build(Comment rootComment, Set<Long> includedCommentIds) {
                CommentThreads commentThreads = new CommentThreads(includedCommentIds);
                commentThreads.buildRecursively(rootComment, null);
                return commentThreads;
            }

            public Set<Long> getCommentIdsInThreads() {
                return this.commentIdsInThreads;
            }

            public Set<CommentThread> getThreads() {
                return this.threads;
            }

            private void buildRecursively(Comment comment, CommentThread parentThread) {
                boolean include = this.includedCommentIds.contains(comment.getId());
                boolean context = !include;
                CommentThread thread = new CommentThread(comment, context);
                if (include) {
                    CommentThread toAdd;
                    if (parentThread != null) {
                        parentThread.addReply(thread);
                    }
                    CommentThread commentThread = toAdd = parentThread == null ? thread : parentThread;
                    if (!this.commentIdsInThreads.contains(toAdd.getComment().getId())) {
                        this.threads.add(toAdd);
                    }
                    this.commentIdsInThreads.add(thread.getComment().getId());
                }
                comment.getComments().forEach(child -> this.buildRecursively((Comment)child, thread));
            }
        }
    }
}

