/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.pull.activity;

import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.mail.SoyMailBuilder;
import com.atlassian.bitbucket.mail.SoyMailMessageRequest;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.watcher.Watchable;
import com.atlassian.stash.internal.notification.handlers.WatchableMailThreadHeaderTransformer;
import com.atlassian.stash.internal.notification.pull.PullRequestNotificationUtils;
import com.atlassian.stash.internal.notification.pull.activity.PullRequestActivityRenderContext;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class PullRequestActivityRenderer {
    private static final String TEMPLATE = "bitbucketPluginNotification.internal.feature.email.emailPullRequestBatch.activities";
    private static final String COUNTS_KEY = "counts";
    private static final String HAS_MORE_ACTIVITY_ITEMS_KEY = "hasMoreActivityItems";
    private static final String ITEMS_KEY = "items";
    private static final String MODULE_KEY_KEY = "moduleKey";
    private static final String PULL_REQUEST_KEY = "pullRequest";
    private final SoyMailBuilder soyMailBuilder;

    public PullRequestActivityRenderer(SoyMailBuilder soyMailBuilder) {
        this.soyMailBuilder = soyMailBuilder;
    }

    public Iterable<MailMessage> render(ApplicationUser user, PullRequestActivityRenderContext context) {
        PullRequest pullRequest = context.getPullRequest();
        I18nKey subjectKey = PullRequestNotificationUtils.createSubjectKey(pullRequest);
        List<Map<String, Object>> items = context.getSortedItems();
        if (items.isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableMap data = ImmutableMap.builder().put((Object)COUNTS_KEY, context.getCounts()).put((Object)HAS_MORE_ACTIVITY_ITEMS_KEY, (Object)context.isTruncated()).put((Object)ITEMS_KEY, items).put((Object)MODULE_KEY_KEY, (Object)"com.atlassian.bitbucket.server.bitbucket-notification:notification-email-styles").put((Object)PULL_REQUEST_KEY, (Object)pullRequest).build();
        return this.soyMailBuilder.build(new SoyMailMessageRequest.Builder().cssModuleKey("com.atlassian.bitbucket.server.bitbucket-notification:notification-email-styles").context((Map)data).recipients(Collections.singleton(user)).soyTemplateModuleKey("com.atlassian.bitbucket.server.bitbucket-notification:notification-email-templates").soyTemplateName(TEMPLATE).subjectKey(subjectKey).messageEffector((Function)new WatchableMailThreadHeaderTransformer((Watchable)pullRequest)).build());
    }
}

