/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.pull.activity;

import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestCommentActivity;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.stash.internal.notification.batch.Data;
import com.atlassian.stash.internal.notification.pull.activity.ActivityData;
import com.atlassian.stash.internal.notification.pull.activity.CommentData;
import com.atlassian.stash.internal.notification.pull.activity.CustomData;
import com.atlassian.stash.internal.notification.pull.activity.ToBranchUpdate;
import com.atlassian.stash.internal.notification.pull.activity.ToBranchUpdateData;
import com.google.common.collect.SetMultimap;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PullRequestBatchData {
    private final Set<PullRequestActivity> activities;
    private final Set<Data> data;
    private final PullRequest pullRequest;
    private final Set<PullRequestCommentActivity> rootCommentActivities;
    private final Map<Integer, ApplicationUser> userIdToUser;
    private final SetMultimap<String, Long> userNameToMentionedCommentIds;

    PullRequestBatchData(@Nonnull Set<PullRequestActivity> activities, @Nonnull Set<Data> data, @Nonnull PullRequest pullRequest, @Nonnull Set<PullRequestCommentActivity> rootCommentActivities, @Nonnull Map<Integer, ApplicationUser> userIdToUser, @Nonnull SetMultimap<String, Long> userNameToMentionedCommentIds) {
        this.activities = Objects.requireNonNull(activities, "activities");
        this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
        this.rootCommentActivities = Objects.requireNonNull(rootCommentActivities, "rootCommentActivities");
        this.userIdToUser = Objects.requireNonNull(userIdToUser, "userIdToUser");
        this.userNameToMentionedCommentIds = Objects.requireNonNull(userNameToMentionedCommentIds, "userNameToMentionedCommentIds");
        this.data = Objects.requireNonNull(data, "data");
    }

    @Nonnull
    public Set<PullRequestActivity> getActivities() {
        Set<Long> activityIds = PullRequestBatchData.getActivityIds(this.data);
        return (Set)this.activities.stream().filter(activity -> activityIds.contains(activity.getId())).collect(MoreCollectors.toImmutableSet());
    }

    @Nonnull
    public Set<Long> getCommentIds() {
        return (Set)PullRequestBatchData.getCommentData(this.data).stream().map(CommentData::getCommentId).collect(MoreCollectors.toImmutableSet());
    }

    @Nonnull
    public Set<Long> getMentionedCommentIds(ApplicationUser user) {
        return this.userNameToMentionedCommentIds.get((Object)user.getName());
    }

    @Nonnull
    public PullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Nonnull
    public Set<ToBranchUpdate> getToBranchUpdates() {
        return (Set)PullRequestBatchData.getBranchUpdateData(this.data).stream().map(branchUpdateData -> {
            ApplicationUser applicationUser = this.userIdToUser.get(branchUpdateData.getUserId());
            return applicationUser == null ? null : new ToBranchUpdate(applicationUser, branchUpdateData.getToBranch(), branchUpdateData.getDate());
        }).filter(Objects::nonNull).collect(MoreCollectors.toImmutableSet());
    }

    @Nonnull
    public Set<PullRequestCommentActivity> getRootCommentActivities() {
        return this.rootCommentActivities;
    }

    static Set<Long> getActivityIds(Iterable<Data> data) {
        return (Set)PullRequestBatchData.filterByType(data, ActivityData.class).stream().map(ActivityData::getActivityId).collect(MoreCollectors.toImmutableSet());
    }

    static Set<ToBranchUpdateData> getBranchUpdateData(Iterable<Data> data) {
        return PullRequestBatchData.filterByType(data, ToBranchUpdateData.class);
    }

    static Set<Integer> getBranchUpdatesUserIds(Iterable<Data> data) {
        return (Set)PullRequestBatchData.getBranchUpdateData(data).stream().map(ToBranchUpdateData::getUserId).collect(MoreCollectors.toImmutableSet());
    }

    static Set<CommentData> getCommentData(Iterable<Data> data) {
        return PullRequestBatchData.filterByType(data, CommentData.class);
    }

    static Set<CustomData> getCustomData(Iterable<Data> data) {
        return PullRequestBatchData.filterByType(data, CustomData.class);
    }

    private static <T> Set<T> filterByType(Iterable<Data> data, Class<T> type) {
        return (Set)MoreStreams.streamIterable(data).filter(type::isInstance).map(type::cast).collect(MoreCollectors.toImmutableSet());
    }
}

