/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.pull.activity;

import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.comment.CommentAction;
import com.atlassian.bitbucket.comment.CommentChain;
import com.atlassian.bitbucket.comment.CommentService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.pull.AbstractPullRequestActivityVisitor;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestActivitySearchRequest;
import com.atlassian.bitbucket.pull.PullRequestActivityType;
import com.atlassian.bitbucket.pull.PullRequestActivityVisitor;
import com.atlassian.bitbucket.pull.PullRequestCommentActivity;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.stash.internal.notification.batch.Data;
import com.atlassian.stash.internal.notification.mention.MentionHelper;
import com.atlassian.stash.internal.notification.pull.activity.CommentData;
import com.atlassian.stash.internal.notification.pull.activity.PullRequestBatchData;
import com.atlassian.stash.internal.notification.pull.activity.PullRequestBatchId;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class PullRequestBatchDataLoader {
    private final CommentService commentService;
    private final MentionHelper mentionHelper;
    private final PullRequestService pullRequestService;
    private final SecurityService securityService;
    private final UserService userService;

    public PullRequestBatchDataLoader(CommentService commentService, MentionHelper mentionHelper, PullRequestService pullRequestService, SecurityService securityService, UserService userService) {
        this.commentService = commentService;
        this.mentionHelper = mentionHelper;
        this.pullRequestService = pullRequestService;
        this.securityService = securityService;
        this.userService = userService;
    }

    public PullRequest getPullRequest(PullRequestBatchId batchId) {
        return (PullRequest)this.securityService.withPermission(Permission.REPO_READ, "Loading pull request for sending batch email").call(() -> this.pullRequestService.getById(batchId.getRepositoryId(), batchId.getPullRequestId()));
    }

    public PullRequestBatchData loadData(PullRequest pullRequest, Set<Data> data) {
        Set<Long> activityIds = PullRequestBatchData.getActivityIds(data);
        Set<CommentData> commentData = PullRequestBatchData.getCommentData(data);
        HashSet<PullRequestActivity> activities = new HashSet<PullRequestActivity>();
        HashSet<PullRequestCommentActivity> rootCommentActivities = new HashSet<PullRequestCommentActivity>();
        this.securityService.withPermission(Permission.REPO_READ, "Loading PR data for sending batch email").call(() -> {
            activities.addAll(this.getActivities(pullRequest, activityIds));
            rootCommentActivities.addAll(this.getRootCommentActivities(pullRequest, commentData));
            return null;
        });
        Map<Integer, ApplicationUser> userIdToUser = this.getUserIdToUser(data);
        SetMultimap<String, Long> commentIdsByMentionedUsers = this.mapUsersToMantionedComments(rootCommentActivities, commentData);
        return new PullRequestBatchData(activities, data, pullRequest, rootCommentActivities, userIdToUser, commentIdsByMentionedUsers);
    }

    private Set<PullRequestActivity> getActivities(PullRequest pullRequest, Set<Long> activityIds) {
        if (activityIds.isEmpty()) {
            return ImmutableSet.of();
        }
        return this.pullRequestService.getActivitiesById(pullRequest.getToRef().getRepository().getId(), pullRequest.getId(), activityIds);
    }

    private Set<PullRequestCommentActivity> getRootCommentActivities(PullRequest pullRequest, Set<CommentData> commentDatas) {
        if (commentDatas.isEmpty()) {
            return ImmutableSet.of();
        }
        Set rootCommentIds = (Set)commentDatas.stream().map(commentData -> commentData.getRootCommentId().orElseGet(() -> {
            Optional comment = this.commentService.getComment(commentData.getCommentId());
            return comment.map(Comment::getId).orElse(null);
        })).filter(Objects::nonNull).distinct().collect(MoreCollectors.toImmutableSet());
        PullRequestActivitySearchRequest searchRequest = new PullRequestActivitySearchRequest.Builder(pullRequest).types(PullRequestActivityType.COMMENT, new PullRequestActivityType[0]).commentActions(CommentAction.ADDED, new CommentAction[0]).commentIds((Iterable)rootCommentIds).build();
        PagedIterable activities = new PagedIterable(request -> this.pullRequestService.searchActivities(searchRequest, request), 0x100000);
        final ImmutableSet.Builder builder = ImmutableSet.builder();
        activities.forEach(activity -> activity.accept((PullRequestActivityVisitor)new AbstractPullRequestActivityVisitor(this){

            public void visit(@Nonnull PullRequestCommentActivity activity) {
                builder.add((Object)activity);
            }
        }));
        return builder.build();
    }

    private Map<Integer, ApplicationUser> getUserIdToUser(Collection<Data> data) {
        Set<Integer> userIds = PullRequestBatchData.getBranchUpdatesUserIds(data);
        if (userIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return (Map)this.userService.getUsersById(userIds, true).stream().collect(MoreCollectors.toImmutableMap(ApplicationUser::getId, Function.identity()));
    }

    private SetMultimap<String, Long> getMentionedUsers(Comment comment, Set<CommentData> commentDatas) {
        HashMultimap mentionedUsers = HashMultimap.create();
        long commentId = comment.getId();
        if (commentDatas.stream().anyMatch(data -> data.getCommentId() == commentId)) {
            this.mentionHelper.getMentionedUsers(comment.getText()).forEach(arg_0 -> PullRequestBatchDataLoader.lambda$getMentionedUsers$7((SetMultimap)mentionedUsers, commentId, arg_0));
        }
        comment.getComments().forEach(arg_0 -> this.lambda$getMentionedUsers$8((SetMultimap)mentionedUsers, commentDatas, arg_0));
        return mentionedUsers;
    }

    private SetMultimap<String, Long> mapUsersToMantionedComments(Set<PullRequestCommentActivity> rootCommentActivities, Set<CommentData> commentDatas) {
        if (rootCommentActivities.isEmpty()) {
            return HashMultimap.create();
        }
        Set rootComments = (Set)rootCommentActivities.stream().map(PullRequestCommentActivity::getComment).collect(MoreCollectors.toImmutableSet());
        HashMultimap mentionedUsers = HashMultimap.create();
        CommentChain.of((Iterable)rootComments).forEach(arg_0 -> this.lambda$mapUsersToMantionedComments$9((SetMultimap)mentionedUsers, commentDatas, arg_0));
        return mentionedUsers;
    }

    private /* synthetic */ void lambda$mapUsersToMantionedComments$9(SetMultimap mentionedUsers, Set commentDatas, Comment comment) {
        mentionedUsers.putAll(this.getMentionedUsers(comment, commentDatas));
    }

    private /* synthetic */ void lambda$getMentionedUsers$8(SetMultimap mentionedUsers, Set commentDatas, Comment child) {
        mentionedUsers.putAll(this.getMentionedUsers(child, commentDatas));
    }

    private static /* synthetic */ void lambda$getMentionedUsers$7(SetMultimap mentionedUsers, long commentId, String user) {
        mentionedUsers.put((Object)user, (Object)commentId);
    }
}

