/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.notification.pull.activity;

import com.atlassian.bitbucket.pull.PullRequest;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PullRequestBatchId {
    private static final Pattern PATTERN = Pattern.compile("(\\d+),(\\d+)");
    private final int repositoryId;
    private final long pullRequestId;

    private PullRequestBatchId(int repositoryId, long pullRequestId) {
        this.repositoryId = repositoryId;
        this.pullRequestId = pullRequestId;
    }

    public static PullRequestBatchId of(@Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        return new PullRequestBatchId(pullRequest.getToRef().getRepository().getId(), pullRequest.getId());
    }

    @Nullable
    public static PullRequestBatchId decode(String batchId) {
        Matcher matcher = PATTERN.matcher(batchId);
        if (matcher.matches()) {
            int repositoryId = Integer.parseInt(matcher.group(1));
            long pullRequestId = Long.parseLong(matcher.group(2));
            return new PullRequestBatchId(repositoryId, pullRequestId);
        }
        return null;
    }

    public String encode() {
        return this.repositoryId + "," + this.pullRequestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PullRequestBatchId)) {
            return false;
        }
        PullRequestBatchId that = (PullRequestBatchId)o;
        return this.repositoryId == that.repositoryId && this.pullRequestId == that.pullRequestId;
    }

    public int getRepositoryId() {
        return this.repositoryId;
    }

    public long getPullRequestId() {
        return this.pullRequestId;
    }

    public int hashCode() {
        return Objects.hash(this.repositoryId, this.pullRequestId);
    }
}

